/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core.object;

public class RSDoor {
    boolean opened;
    byte stage;
    byte stagePrev;
    final byte stageMax;

    public RSDoor(byte stageMax) {
        this(stageMax, 0, false);
    }

    public RSDoor(byte stageMax, byte stage, boolean opened) {
        this.stageMax = stageMax;
        this.stage = stage;
        this.stagePrev = stage;
        this.opened = opened;
    }

    public boolean tryTrigger() {
        if (this.stage == 0 || this.stage == this.stageMax) {
            this.forceTrigger();
            return true;
        }
        return false;
    }

    public void forceTrigger() {
        this.opened = !this.opened;
    }

    public void onUpdate() {
        this.stagePrev = this.stage;
        this.stage = this.opened ? (this.stage < this.stageMax ? (byte)(this.stage + 1) : this.stageMax) : (this.stage > 0 ? (byte)(this.stage - 1) : (byte)0);
    }

    public boolean isFullyOpened() {
        return this.opened && this.stage == this.stageMax;
    }

    public boolean isFullyClosed() {
        return !this.opened && this.stage == 0;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public byte getStage() {
        return this.stage;
    }

    public float getStage(float partialTick) {
        return (float)this.stagePrev + (float)(this.stage - this.stagePrev) * partialTick;
    }

    public float getStageRelative(float partialTick) {
        return this.getStage(partialTick) / (float)this.stageMax;
    }
}

