/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.loco;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.row.entity.EntityCartRider;
import net.row.helpers.RotativePoint;
import net.row.helpers.UtilSync;
import net.row.item.ItemKey;
import net.row.registry.RoWConfig;
import net.row.registry.RoWItems;
import net.row.renderer.particle.ParticleSmokePuff;
import net.row.stock.core.RoWLocomotiveSteam;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.core.object.RSDoor;

public class LocoYer
extends RoWLocomotiveSteam {
    public RSDoor RSDoor;
    public byte doorTime;
    public int tankFuel;
    public int tankFuelCap;

    public LocoYer(World par1World) {
        super(par1World);
        this.hasLight = true;
        this.modified = 0;
        this.func_70105_a(2.875f, 3.75f);
        this.bareMass = 44.0f;
        this.maxForce = 40.0f;
        this.releaseSpeed = 0.17f;
        this.forceScale = 45.0f;
        this.R_const = 9.0f;
        this.C_stiction = 378.0f;
        this.fuelCap = 300;
        this.tankFuelCap = 10000;
        this.fuelChance = 0.3f;
        this.maxLabelSize = (byte)8;
        this.riderPos = new RotativePoint(this, -0.875f, 2.0625f, -3.1875f);
        this.chimneyPos = new RotativePoint(this, 0.0f, 4.25f, 2.375f);
        this.whistlePos = new RotativePoint(this, 0.0f, 3.875f, -1.25f);
        this.lightsPos = new RotativePoint(this, 0.0f, 0.75f, 4.125f);
        this.steamPosLeft = new RotativePoint(this, 0.9375f, 0.625f, 2.0f);
        this.steamPosRight = new RotativePoint(this, -0.9375f, 0.625f, 2.0f);
        this.frontCouplerShift = 4.0625f;
        this.rearCouplerShift = 4.6875f;
        this.dismountPosRight = new RotativePoint(this, -2.0f, 1.0f, -3.3125f);
        this.dismountPosLeft = new RotativePoint(this, 2.0f, 1.0f, -3.3125f);
        this.walkableMinX = -0.875f;
        this.walkableMinZ = -3.25f;
        this.walkableMaxX = 0.875f;
        this.walkableMaxZ = -3.125f;
        this.hornSound = "whistle_yer";
        this.pistonSoundI = "piston_ov_i";
        this.pistonSoundO = "piston_ov_o";
        this.label = "b-2023";
        this.wheelRadius = new float[]{0.5f};
        this.wheelAngle = new float[]{0.0f};
        this.axleShifts = new float[]{1.4375f, 1.4375f, 1.4375f};
        this.doorTime = (byte)4;
        this.RSDoor = new RSDoor(this.doorTime);
        this.couplerFrontType = RoWRollingStock.CouplerType.BnC_RUSS;
        this.couplerRearType = RoWRollingStock.CouplerType.BnC_RUSS;
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        ItemStack stack;
        if (!this.field_70170_p.field_72995_K && (stack = player.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemKey && stack.field_77994_a > 0 && this.RSDoor.tryTrigger()) {
            if (this.RSDoor.isOpened()) {
                this.field_70170_p.func_72956_a((Entity)this, "row:door_open", 1.0f, 1.0f);
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "row:door_close", 1.0f, 1.0f);
            }
            this.sendUpdateToClient();
            return true;
        }
        return super.func_130002_c(player);
    }

    @Override
    public boolean interactMount(EntityPlayer player) {
        if (this.canBeRidden() && player.field_70154_o == null && !player.func_70093_af() && this.RSDoor.isFullyOpened()) {
            this.seat = new EntityCartRider(this);
            this.field_70170_p.func_72838_d((Entity)this.seat);
            player.func_70078_a((Entity)this.seat);
            if (RoWConfig.automaticDoorClose) {
                this.RSDoor.tryTrigger();
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "row:door_close", 1.0f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean interactFuel(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null && item.func_77973_b().equals(Items.field_151044_h)) {
            if (player.field_71075_bZ.field_75098_d) {
                this.tankFuel = this.tankFuelCap;
                UtilSync.sync(this);
                return true;
            }
            int itemValue = RoWConfig.coalFuelValue;
            if (this.tankFuel + itemValue < this.tankFuelCap) {
                if (this.tankFuel + item.field_77994_a * itemValue < this.tankFuelCap) {
                    this.tankFuel += item.field_77994_a * itemValue;
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else {
                    int canConsumeItems = Math.min((this.tankFuelCap - this.tankFuel) / itemValue, item.field_77994_a);
                    this.tankFuel += canConsumeItems * RoWConfig.coalFuelValue;
                    item.field_77994_a -= canConsumeItems;
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, item.field_77994_a == 0 ? null : item);
                }
                UtilSync.sync(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.RSDoor.onUpdate();
        if (this.stokerStage == this.stokerStageMax && this.fuel < this.fuelCap && this.tankFuel > 0) {
            ++this.fuel;
            --this.tankFuel;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnFx() {
        if (Math.random() < (double)this.fxChance) {
            if (Math.random() < 0.98) {
                ParticleSmokePuff fx = new ParticleSmokePuff(this.field_70170_p, this.chimneyPos.getX(), (double)(this.chimneyPos.getY() + 0.25f) + Math.random() * 0.5, this.chimneyPos.getZ(), 0.0, 0.0, 0.0, 3.5f, 3.5f);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
            } else {
                EntityExplodeFX fx = new EntityExplodeFX(this.field_70170_p, (double)this.chimneyPos.getX(), (double)this.chimneyPos.getY() + Math.random() * 0.5, (double)this.chimneyPos.getZ(), 0.0, 0.0, 0.0);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnPistonFxLeft() {
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            EntityExplodeFX steamfx = new EntityExplodeFX(this.field_70170_p, (double)this.steamPosLeft.getX(), (double)this.steamPosLeft.getY(), (double)this.steamPosLeft.getZ(), 0.0, 0.0, 0.0);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)steamfx);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnPistonFxRight() {
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            EntityExplodeFX steamfx = new EntityExplodeFX(this.field_70170_p, (double)this.steamPosRight.getX(), (double)this.steamPosRight.getY(), (double)this.steamPosRight.getZ(), 0.0, 0.0, 0.0);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)steamfx);
        }
    }

    @Override
    public void processPistonFxs(byte wheelQuad, byte lastWheelQuad) {
        if (wheelQuad == 0 || wheelQuad == 2) {
            this.spawnPistonFxRight();
        } else {
            this.spawnPistonFxLeft();
        }
    }

    @Override
    public ItemStack getDrops() {
        return new ItemStack(RoWItems.itemStock, 1, 4 + this.modified);
    }

    @Override
    public boolean canMount() {
        return this.RSDoor.isFullyOpened();
    }

    @Override
    public boolean canDismount() {
        return this.RSDoor.isFullyOpened();
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.RSDoor = new RSDoor(this.doorTime, tag.func_74771_c("stage"), tag.func_74767_n("opened"));
        this.tankFuel = tag.func_74762_e("tankFuel");
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("opened", this.RSDoor.isOpened());
        tag.func_74774_a("stage", this.RSDoor.getStage());
        tag.func_74768_a("tankFuel", this.tankFuel);
    }
}

