/*
 * Decompiled with CFR 0.152.
 */
package net.row.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.row.RoW;

public class TileEntityTrackNormal
extends TileEntity {
    public int type = -1;
    public byte state = 0;
    public byte progress = 0;
    public float turntableProgress = 0.0f;
    public boolean activated = false;
    public boolean prevActivated = false;
    public boolean hasSwitchmotor = false;
    public boolean hasTrain = false;
    public byte cooldown = 0;

    public boolean canUpdate() {
        return true;
    }

    public boolean isStraight() {
        return this.type == 0 || this.type == 1 || this.type == 33;
    }

    public boolean isSlope() {
        return this.type >= 6 && this.type <= 8;
    }

    public boolean isRadial() {
        return this.isArc() || this.isLane() || this.isSwitchByType();
    }

    public float getRadius() {
        if (this.isRadial()) {
            if (this.type == 9 || this.type == 10 || this.type == 15 || this.type == 16) {
                return 31.695f;
            }
            if (this.type == 11 || this.type == 12 || this.type == 17 || this.type == 18) {
                return 63.08f;
            }
            if (this.type == 13 || this.type == 14 || this.type == 19 || this.type == 20) {
                return 89.6375f;
            }
            if (this.type == 21 || this.type == 22 || this.type == 27 || this.type == 28) {
                return 62.0352f;
            }
            if (this.type == 23 || this.type == 24 || this.type == 29 || this.type == 30) {
                return 59.9031f;
            }
            if (this.type == 25 || this.type == 26 || this.type == 31 || this.type == 32) {
                return 62.4609f;
            }
        }
        return Float.POSITIVE_INFINITY;
    }

    public boolean isArc() {
        return this.type >= 9 && this.type <= 14;
    }

    public boolean isLane() {
        return this.type >= 21 && this.type <= 26;
    }

    public boolean isSwitchCircular() {
        return this.type >= 15 && this.type <= 20;
    }

    public boolean isSwitchParallel() {
        return this.type >= 27 && this.type <= 32;
    }

    public boolean isSwitchByType() {
        return this.isSwitchCircular() || this.isSwitchParallel();
    }

    public boolean isSwitchBySize() {
        return this.isSwitch1() || this.isSwitch2();
    }

    public boolean isSwitch1() {
        return this.type == 15 || this.type == 16;
    }

    public boolean isSwitch2() {
        return this.type >= 17 && this.type <= 20 || this.type >= 27 && this.type <= 32;
    }

    public boolean isTurntable() {
        return this.type == 16;
    }

    public void func_145845_h() {
        if (this.cooldown > 0) {
            this.cooldown = (byte)(this.cooldown - 1);
        } else {
            this.hasTrain = false;
            RoW.getTrackManager(this.field_145850_b).updateTrack(this.field_145850_b, new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
        }
        if (!this.isSwitchBySize() && !this.isTurntable()) {
            return;
        }
        this.progress = this.activated ? (this.progress < 10 ? (byte)(this.progress + 1) : (byte)10) : (this.progress > 0 ? (byte)(this.progress - 1) : (byte)0);
        if (this.type == 16) {
            float angle = MathHelper.func_76142_g((float)((float)this.state * 45.0f));
            this.turntableProgress = MathHelper.func_76142_g((float)this.turntableProgress);
            float d = MathHelper.func_76142_g((float)(angle - this.turntableProgress));
            this.turntableProgress = (double)Math.abs(angle - this.turntableProgress) < 0.5 ? angle : (this.turntableProgress += 0.5f * Math.signum(d));
        }
        if (this.hasSwitchmotor && (this.activated && !this.prevActivated || !this.activated && this.prevActivated)) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "row:switchmotor", 1.0f, 1.0f, false);
        }
        this.prevActivated = this.activated;
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("mid", this.type);
        par1NBTTagCompound.func_74774_a("state", this.state);
        par1NBTTagCompound.func_74776_a("trt", this.turntableProgress);
        par1NBTTagCompound.func_74757_a("act", this.activated);
        par1NBTTagCompound.func_74757_a("motor", this.hasSwitchmotor);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.type = par1NBTTagCompound.func_74762_e("mid");
        this.state = par1NBTTagCompound.func_74771_c("state");
        this.turntableProgress = par1NBTTagCompound.func_74760_g("trt");
        this.activated = par1NBTTagCompound.func_74767_n("act");
        this.hasSwitchmotor = par1NBTTagCompound.func_74767_n("motor");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

