/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class StateGraph<T> {
    private State<T> state;

    private StateGraph(Builder<T> builder) {
        this.state = ((Builder)builder).state;
    }

    public static <T> Predicate<? super T> runOnce(Consumer<? super T> consumer) {
        return t -> {
            consumer.accept(t);
            return true;
        };
    }

    public void offer(T data) {
        this.state = this.state.accept(data);
    }

    private static final class WaitState<T>
    extends ParentState<T> {
        final int duration;
        int countdown;

        WaitState(State<T> child, int duration) {
            super(child);
            this.duration = duration;
            this.countdown = duration;
        }

        @Override
        public State<T> init() {
            this.countdown = this.duration;
            return super.init();
        }

        @Override
        public State<T> accept(T data) {
            if (--this.countdown < 0) {
                return this.child.init().accept(data);
            }
            if (this.countdown == 0) {
                return this.child.init();
            }
            return this;
        }

        @Override
        public State<T> andThen(State<T> other) {
            return new WaitState<T>(this.child.andThen(other), this.countdown);
        }
    }

    private static final class RunState<T>
    extends ParentState<T> {
        final Predicate<? super T> function;

        RunState(State<T> child, Predicate<? super T> function) {
            super(child);
            this.function = function;
        }

        @Override
        public State<T> accept(T data) {
            return this.function.test(data) ? this.child.init() : this;
        }

        @Override
        public State<T> andThen(State<T> other) {
            return new RunState<T>(this.child.andThen(other), this.function);
        }
    }

    private static abstract class ParentState<T>
    implements State<T> {
        final State<T> child;

        ParentState(State<T> child) {
            this.child = child;
        }
    }

    private static final class JumpState<T>
    implements State<T> {
        final Predicate<? super T> condition;
        State<T> first;
        State<T> second;

        private JumpState(Predicate<? super T> condition, State<T> first, State<T> second) {
            this.condition = condition;
            this.first = first;
            this.second = second;
        }

        @Override
        public State<T> accept(T data) {
            return this.condition.test(data) ? this.first.init().accept(data) : this.second;
        }

        @Override
        public State<T> andThen(State<T> other) {
            this.second = this.second.andThen(other);
            return this;
        }
    }

    private static class BranchState<T>
    implements State<T> {
        final Predicate<? super T> condition;
        final State<T> first;
        final State<T> second;

        private BranchState(Predicate<? super T> condition, State<T> first, State<T> second) {
            this.condition = condition;
            this.first = first;
            this.second = second;
        }

        @Override
        public State<T> accept(T data) {
            return this.condition.test(data) ? this.first.init().accept(data) : this.second.init().accept(data);
        }

        @Override
        public State<T> andThen(State<T> other) {
            return new BranchState<T>(this.condition, this.first.andThen(other), this.second.andThen(other));
        }
    }

    private static final class NoOpState<T>
    implements State<T> {
        private NoOpState() {
        }

        @Override
        public State<T> accept(T data) {
            return this;
        }

        @Override
        public State<T> andThen(State<T> other) {
            return other;
        }
    }

    public static final class Builder<T> {
        private State<T> state = new NoOpState();

        public Builder<T> runOnce(Consumer<? super T> function) {
            return this.run(StateGraph.runOnce(function));
        }

        public Builder<T> run(Predicate<? super T> function) {
            return this.andThen(new RunState<T>(new NoOpState(), function));
        }

        public Builder<T> runOnceIf(Predicate<? super T> condition, Consumer<? super T> function) {
            return this.runIf(condition, StateGraph.runOnce(function));
        }

        public Builder<T> runIf(Predicate<? super T> condition, Predicate<? super T> function) {
            return this.andThen(new BranchState(condition, new RunState<T>(new NoOpState(), function), new NoOpState()));
        }

        public Builder<T> wait(int duration) {
            if (duration > 0) {
                return this.andThen(new WaitState(new NoOpState(), duration));
            }
            return this;
        }

        public Builder<T> waitIf(Predicate<? super T> condition, int duration) {
            if (duration > 0) {
                return this.andThen(new BranchState(condition, new WaitState(new NoOpState(), duration), new NoOpState()));
            }
            return this;
        }

        public Builder<T> runWhile(Predicate<? super T> condition, UnaryOperator<Builder<T>> consumer) {
            JumpState guard = new JumpState(condition, new NoOpState(), new NoOpState());
            guard.first = ((Builder)consumer.apply(new Builder<T>())).andThen(guard).state;
            return this.andThen(guard);
        }

        Builder<T> andThen(State<T> other) {
            this.state = this.state.andThen(other);
            return this;
        }

        public StateGraph<T> build() {
            return new StateGraph(this);
        }
    }

    public static interface State<T> {
        default public State<T> init() {
            return this;
        }

        public State<T> accept(T var1);

        public State<T> andThen(State<T> var1);
    }
}

