/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.arena;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.saving.AbstractSaveHandler;
import com.teamwizardry.librarianlib.features.saving.Savable;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.util.ColorUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.entity.angel.EntityAngel;
import com.teamwizardry.wizardry.common.entity.angel.zachriel.EntityZachriel;
import java.awt.Color;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Savable
public class Arena
implements INBTSerializable<NBTTagCompound> {
    private transient World world;
    private transient EntityAngel boss;
    @Save
    private int worldID;
    @Save
    private BlockPos center;
    @Save
    private double radius;
    @Save
    private double height;
    @Save
    private int bossID;
    @Save
    private Set<UUID> players;
    @Save
    private boolean isActive = true;
    @Save
    private boolean hasEnded = false;
    @Save
    private long startTick = 0L;

    public Arena(int worldID, BlockPos center, double radius, double height, int bossID, Set<UUID> players) {
        this.worldID = worldID;
        this.world = DimensionManager.getWorld((int)worldID);
        this.boss = (EntityAngel)this.world.func_73045_a(bossID);
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.bossID = bossID;
        this.players = players;
    }

    public boolean sanityCheck() {
        for (double x = -this.radius; x < this.radius; x += 1.0) {
            for (double z = -this.radius; z < this.radius; z += 1.0) {
                int y = 0;
                while ((double)y < this.height) {
                    BlockPos pos = this.center.func_177963_a(x, (double)y, z);
                    if (pos.func_185332_f(this.center.func_177958_n(), this.center.func_177956_o(), this.center.func_177952_p()) > this.radius) {
                        LibParticles.STRUCTURE_FLAIR(this.world, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), Color.RED);
                        return false;
                    }
                    if (!this.world.func_175710_j(pos)) {
                        LibParticles.STRUCTURE_FLAIR(this.world, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), Color.GREEN);
                        return false;
                    }
                    if (!this.world.func_175623_d(pos)) {
                        LibParticles.STRUCTURE_FLAIR(this.world, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), Color.BLUE);
                        return false;
                    }
                    ++y;
                }
            }
        }
        return true;
    }

    public void dealWithStructureConflict() {
    }

    public void begin() {
        this.isActive = true;
        this.hasEnded = false;
        this.startTick = System.currentTimeMillis();
    }

    public void tick(long timeMillis) {
        if (timeMillis % 500L == 0L) {
            ClientRunnable.run((ClientRunnable)new ClientRunnable(){

                @SideOnly(value=Side.CLIENT)
                public void runIfClient() {
                    ParticleBuilder glitter = new ParticleBuilder(10);
                    glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                    glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
                    glitter.setCollision(true);
                    glitter.enableMotionCalculation();
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)Arena.this.getWorld(), (InterpFunction)new InterpCircle(new Vec3d((Vec3i)Arena.this.getCenter()).func_72441_c(0.5, Arena.this.getHeight(), 0.5), new Vec3d(0.0, 1.0, 0.0), (float)Arena.this.getRadius(), 1.0f, RandUtil.nextFloat()), (int)10, (int)RandUtil.nextInt(10), (aFloat, particleBuilder) -> {
                        particleBuilder.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
                        particleBuilder.setScale(RandUtil.nextFloat(0.5f, 1.0f));
                        particleBuilder.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
                        particleBuilder.setLifetime(RandUtil.nextInt(30, 60));
                    });
                    glitter.disableMotionCalculation();
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)Arena.this.getWorld(), (InterpFunction)new InterpCircle(new Vec3d((Vec3i)Arena.this.getCenter()).func_72441_c(0.5, 0.0, 0.5), new Vec3d(0.0, 1.0, 0.0), (float)Arena.this.getRadius(), 1.0f, RandUtil.nextFloat()), (int)10, (int)RandUtil.nextInt(10), (aFloat, particleBuilder) -> {
                        particleBuilder.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
                        particleBuilder.setScale(RandUtil.nextFloat(0.5f, 1.0f));
                        particleBuilder.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.01, 0.02), RandUtil.nextDouble(-0.01, 0.01)));
                        particleBuilder.setLifetime(RandUtil.nextInt(30, 60));
                    });
                }
            });
        }
    }

    public void end() {
        this.hasEnded = true;
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public boolean hasEnded() {
        return this.hasEnded;
    }

    public World getWorld() {
        return this.world;
    }

    public int getWorldID() {
        return this.worldID;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getHeight() {
        return this.height;
    }

    public int getBossID() {
        return this.bossID;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public Iterable<EntityLivingBase> getVictims() {
        return this.world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.center).func_72314_b(this.radius, 0.0, this.radius).func_72321_a(0.0, this.height, 0.0), entity -> entity != null && entity.func_70089_S() && entity.func_184603_cC() && !(entity instanceof EntityZachriel) && entity.func_174818_b(this.center) < this.radius * this.radius);
    }

    public boolean isHasEnded() {
        return this.hasEnded;
    }

    public void setHasEnded(boolean hasEnded) {
        this.hasEnded = hasEnded;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("save", AbstractSaveHandler.writeAutoNBT((Object)this, (boolean)true));
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        AbstractSaveHandler.readAutoNBT((Object)this, (NBTBase)nbt.func_74775_l("save"), (boolean)true);
    }

    public EntityAngel getBoss() {
        return this.boss;
    }
}

