/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.block;

import com.teamwizardry.librarianlib.features.saving.Module;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.wizardry.api.block.IManaGenerator;
import com.teamwizardry.wizardry.api.block.TileCachable;
import com.teamwizardry.wizardry.api.capability.player.mana.CustomManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaModule;
import com.teamwizardry.wizardry.common.tile.TileCraftingPlate;
import com.teamwizardry.wizardry.common.tile.TileManaBattery;
import com.teamwizardry.wizardry.common.tile.TileOrbHolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TileManaNode
extends TileCachable
implements ITickable {
    private static ArrayList<SuckRule> suckRules = new ArrayList();
    @Module
    public ManaModule cap;
    @Save
    private boolean canSuckFromOutside = true;
    @Save
    private boolean canGiveToOutside = true;
    @Save
    @Nullable
    private BlockPos structurePos = null;

    public TileManaNode(double maxMana, double maxBurnout) {
        this.cap = new ManaModule(new CustomManaCapability(maxMana, maxBurnout));
    }

    public static void addSuckRule(SuckRule suckRule) {
        suckRules.add(suckRule);
    }

    public void func_73660_a() {
        if (this.distanceCache.isEmpty()) {
            return;
        }
        if (this.suckManaAutomatically()) {
            this.suckMana(this.getWizardryCap());
        }
    }

    public boolean suckManaAutomatically() {
        return true;
    }

    private static boolean checkStructureCompat(TileManaNode to, TileManaNode from) {
        return from.isPartOfStructure() && to.isPartOfStructure() && from.canGiveToOutside() && to.canSuckFromOutside() || from.isPartOfStructure() && !to.isPartOfStructure() && from.canGiveToOutside() || from.isPartOfStructure() && to.isPartOfStructure() && from.getStructurePos().equals((Object)to.getStructurePos()) || !from.isPartOfStructure() && !to.isPartOfStructure();
    }

    public double suckMana(IManaCapability cap) {
        double totalZucced = 0.0;
        if (ManaManager.isManaFull(cap)) {
            return 0.0;
        }
        block0: for (SuckRule suckRule : suckRules) {
            if (!((Object)((Object)this)).getClass().isAssignableFrom(suckRule.thisClazz)) continue;
            ArrayList nodes = this.getNearestNodes(suckRule.fromClazz);
            nodes.sort(Comparator.comparingDouble(this::getCachedDistanceSq));
            int i = 0;
            for (TileManaNode from : nodes) {
                double zucced;
                if (from == null || !((zucced = this.suckManaFrom(from, suckRule, cap)) > 0.0)) continue;
                totalZucced += zucced;
                from.onDrainedFrom(this);
                this.onSuckFrom(from);
                if (++i <= suckRule.getNbOfConnections()) continue;
                continue block0;
            }
        }
        return totalZucced;
    }

    @Nullable
    public IManaCapability getWizardryCap() {
        return (IManaCapability)this.cap.getHandler();
    }

    public void onDrainedFrom(TileManaNode from) {
    }

    public void onSuckFrom(TileManaNode from) {
    }

    public boolean isPartOfStructure() {
        return this.structurePos != null;
    }

    @Nullable
    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public void setStructurePos(@Nullable BlockPos structurePos) {
        this.structurePos = structurePos;
    }

    @Nonnull
    public Vec3d getOffset() {
        return Vec3d.field_186680_a;
    }

    public boolean canSuckFromOutside() {
        return this.canSuckFromOutside;
    }

    public void setCanSuckFromOutside(boolean canSuckFromOutside) {
        this.canSuckFromOutside = canSuckFromOutside;
    }

    /*
     * Exception decompiling
     */
    public double suckManaFrom(TileManaNode interacterFrom, SuckRule suckRule, IManaCapability cap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 58[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public double drainMana(double mana) {
        if (!this.field_145850_b.func_175667_e(this.field_174879_c)) {
            return -1.0;
        }
        IManaCapability cap = this.getWizardryCap();
        if (cap == null) {
            return -1.0;
        }
        double amount = MathHelper.func_151237_a((double)cap.getMana(), (double)0.0, (double)mana);
        ManaManager.forObject(cap).removeMana(amount).close();
        return amount;
    }

    public boolean canGiveToOutside() {
        return this.canGiveToOutside;
    }

    public void setCanGiveToOutside(boolean canGiveToOutside) {
        this.canGiveToOutside = canGiveToOutside;
    }

    static {
        TileManaNode.addSuckRule(new SuckRule<TileOrbHolder, TileOrbHolder>(0, 1.0, true, 1, TileOrbHolder.class, TileOrbHolder.class, (to, from) -> {
            World world = to.field_145850_b;
            if (world == null) {
                return false;
            }
            if (!TileManaNode.checkStructureCompat(to, from)) {
                return false;
            }
            if (from.isPartOfStructure()) {
                TileEntity tile = world.func_175625_s(from.getStructurePos());
                if (tile instanceof IManaGenerator && to.isPartOfStructure() && to.getStructurePos().equals((Object)from.getStructurePos())) {
                    return true;
                }
                return !(tile instanceof IManaGenerator) || to.isPartOfStructure() && to.getStructurePos().equals((Object)from.getStructurePos());
            }
            return true;
        }));
        TileManaNode.addSuckRule(new SuckRule<TileOrbHolder, TileOrbHolder>(0, 1.0, false, 1, TileOrbHolder.class, TileOrbHolder.class, (to, from) -> {
            World world = to.field_145850_b;
            if (world == null) {
                return false;
            }
            if (!TileManaNode.checkStructureCompat(to, from)) {
                return false;
            }
            if (from.isPartOfStructure()) {
                TileEntity tile = world.func_175625_s(from.getStructurePos());
                return tile instanceof IManaGenerator && (!to.isPartOfStructure() || !to.getStructurePos().equals((Object)from.getStructurePos()));
            }
            return false;
        }));
        TileManaNode.addSuckRule(new SuckRule<TileOrbHolder, TileManaBattery>(1, 1.0, false, 1, TileOrbHolder.class, TileManaBattery.class, TileManaNode::checkStructureCompat));
        TileManaNode.addSuckRule(new SuckRule<TileCraftingPlate, TileOrbHolder>(1, 0.25, false, 4, TileCraftingPlate.class, TileOrbHolder.class, TileManaNode::checkStructureCompat));
        suckRules.sort(Comparator.comparingInt(SuckRule::getPriority));
    }

    public static class SuckRule<K extends TileManaNode, T extends TileManaNode> {
        private final int priority;
        private final double idealAmount;
        private final boolean equalize;
        private final int nbOfConnections;
        private final Class<K> thisClazz;
        private final Class<T> fromClazz;
        @Nullable
        private final BiPredicate<K, T> condition;

        public SuckRule(int priority, double idealAmount, boolean equalize, int nbOfConnections, Class<K> thisClazz, Class<T> fromClazz, @Nullable BiPredicate<K, T> condition) {
            this.priority = priority;
            this.idealAmount = idealAmount;
            this.equalize = equalize;
            this.nbOfConnections = nbOfConnections;
            this.thisClazz = thisClazz;
            this.fromClazz = fromClazz;
            this.condition = condition;
        }

        public double getIdealAmount() {
            return this.idealAmount;
        }

        public boolean isEqualize() {
            return this.equalize;
        }

        public Class<K> getThisClazz() {
            return this.thisClazz;
        }

        public Class<T> getFromClazz() {
            return this.fromClazz;
        }

        @Nullable
        public BiPredicate<K, T> getCondition() {
            return this.condition;
        }

        public int getNbOfConnections() {
            return this.nbOfConnections;
        }

        public int getPriority() {
            return this.priority;
        }

        static /* synthetic */ BiPredicate access$200(SuckRule x0) {
            return x0.condition;
        }

        static /* synthetic */ boolean access$300(SuckRule x0) {
            return x0.equalize;
        }

        static /* synthetic */ double access$400(SuckRule x0) {
            return x0.idealAmount;
        }
    }
}

