/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.entity.fairy;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.capability.player.mana.CustomManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.util.ColorUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class FairyData
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    public boolean wasTamperedWith = false;
    public Color primaryColor = ColorUtils.generateRandomColor();
    public Color secondaryColor = ColorUtils.generateRandomColor();
    public int age = RandUtil.nextInt(100, 500);
    public boolean isDepressed = false;
    @Nonnull
    public final List<SpellRing> infusedSpell = new ArrayList<SpellRing>();
    @Nullable
    public UUID owner = null;
    public final IManaCapability handler = new CustomManaCapability(1000.0, 1000.0, 0.0, 0.0);

    public FairyData() {
    }

    public FairyData(boolean wasTamperedWith, @NotNull Color primaryColor, @NotNull Color secondaryColor, int age, boolean isDepressed, @Nonnull List<SpellRing> infusedSpell, @Nullable UUID owner, @NotNull IManaCapability handler) {
        this.wasTamperedWith = wasTamperedWith;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.age = age;
        this.isDepressed = isDepressed;
        this.infusedSpell.clear();
        this.infusedSpell.addAll(infusedSpell);
        this.owner = owner;
        this.handler.deserializeNBT(handler.serializeNBT());
    }

    @Nullable
    public static FairyData deserialize(NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        FairyData fairyData = new FairyData();
        fairyData.deserializeNBT(compound);
        return fairyData;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, Vec3d pos, Vec3d prevPos, float partialTicks) {
        if (!this.wasTamperedWith && !this.isDepressed) {
            LibParticles.FAIRY_HEAD(world, pos.func_72441_c(0.0, 0.25, 0.0), this.primaryColor);
            ParticleBuilder glitter = new ParticleBuilder(this.age / 2);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
            if (RandUtil.nextInt(3) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (i, build) -> {
                    build.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
                    if (RandUtil.nextBoolean()) {
                        build.setColor(this.primaryColor);
                    } else {
                        build.setColor(this.secondaryColor);
                    }
                    if (this.isDepressed) {
                        build.setCollision(true);
                        build.enableMotionCalculation();
                        build.setAcceleration(new Vec3d(0.0, -0.005, 0.0));
                    }
                });
            }
        } else {
            int i2;
            Vec3d posPerp;
            GlStateManager.func_179094_E();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            GlStateManager.func_179137_b((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            GlStateManager.func_179126_j();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179142_g();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            int alphaFunc = GL11.glGetInteger((int)3009);
            float alphaTest = GL11.glGetFloat((int)3010);
            GlStateManager.func_179092_a((int)519, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2 ? -1 : 1) * Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bb = tessellator.func_178180_c();
            double radius = 0.1;
            Color color = this.primaryColor;
            bb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            for (int i3 = 0; i3 <= 50; ++i3) {
                double x = radius * (double)MathHelper.func_76134_b((float)((float)((double)i3 / 50.0 * Math.PI * 2.0)));
                double z = radius * (double)MathHelper.func_76126_a((float)((float)((double)i3 / 50.0 * Math.PI * 2.0)));
                bb.func_181662_b(x, z, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            bb.func_181668_a(4, DefaultVertexFormats.field_181706_f);
            Vec3d sub = pos.func_178788_d(prevPos).func_186678_a(-1.0).func_72441_c(0.0, 0.2, 0.0).func_186678_a(3.0);
            Vec3d posCross = sub.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
            Vec3d vec1 = posPerp = posCross.func_72431_c(sub).func_72432_b().func_186678_a(radius - 0.2);
            Vec3d vec2 = posPerp.func_186678_a(-1.0);
            bb.func_181662_b(sub.field_72450_a, sub.field_72448_b, sub.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            bb.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            bb.func_181662_b(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            Vec3d vec3 = posCross.func_186678_a(radius);
            Vec3d vec4 = posCross.func_186678_a(-1.0).func_186678_a(radius);
            bb.func_181662_b(sub.field_72450_a, sub.field_72448_b, sub.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            bb.func_181662_b(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            bb.func_181662_b(vec4.field_72450_a, vec4.field_72448_b, vec4.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2 ? -1 : 1) * Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            int sections = 50;
            float epsilon = (float)Math.PI * 2 / (float)sections;
            double innerRadius = radius;
            double outerRadius = radius + 0.01;
            Color inner = this.primaryColor;
            Color outer = new Color(this.primaryColor.getRed(), this.primaryColor.getGreen(), this.primaryColor.getBlue(), 0);
            bb.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (i2 = 0; i2 <= sections; ++i2) {
                float angle = (float)i2 * epsilon;
                float nextAngle = (float)(i2 + 1) * epsilon;
                float x1 = (float)((double)MathHelper.func_76134_b((float)angle) * innerRadius);
                float y1 = (float)((double)MathHelper.func_76126_a((float)angle) * innerRadius);
                float x2 = (float)((double)MathHelper.func_76134_b((float)nextAngle) * outerRadius);
                float y2 = (float)((double)MathHelper.func_76126_a((float)nextAngle) * outerRadius);
                bb.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(inner.getRed(), inner.getGreen(), inner.getBlue(), inner.getAlpha()).func_181675_d();
                bb.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(outer.getRed(), outer.getGreen(), outer.getBlue(), outer.getAlpha()).func_181675_d();
            }
            tessellator.func_78381_a();
            radius = 0.2;
            color = this.secondaryColor;
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.01);
            bb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bb.func_181662_b(0.0, 0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 100).func_181675_d();
            for (i2 = 0; i2 <= 50; ++i2) {
                double x = radius * (double)MathHelper.func_76134_b((float)((float)((double)i2 / 50.0 * Math.PI * 2.0)));
                double z = radius * (double)MathHelper.func_76126_a((float)((float)((double)i2 / 50.0 * Math.PI * 2.0)));
                bb.func_181662_b(x, z, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.01);
            GlStateManager.func_179092_a((int)alphaFunc, (float)alphaTest);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179119_h();
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ManaCapabilityProvider.MANA_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == ManaCapabilityProvider.MANA_CAPABILITY ? this.handler : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("tampered_with", this.wasTamperedWith);
        compound.func_74768_a("primary_color", this.primaryColor.getRGB());
        compound.func_74768_a("secondary_color", this.secondaryColor.getRGB());
        compound.func_74768_a("age", this.age);
        compound.func_74757_a("depressed", this.isDepressed);
        if (this.owner != null) {
            NBTHelper.setUniqueId((NBTTagCompound)compound, (String)"owner_id", (UUID)this.owner);
        }
        NBTHelper.setCompoundTag((NBTTagCompound)compound, (String)"mana_capability", (NBTTagCompound)((NBTTagCompound)this.handler.serializeNBT()));
        NBTTagList list = new NBTTagList();
        for (SpellRing chain : this.infusedSpell) {
            list.func_74742_a((NBTBase)chain.serializeNBT());
        }
        NBTHelper.setTagList((NBTTagCompound)compound, (String)"infused_spell", (NBTTagList)list);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        this.wasTamperedWith = NBTHelper.getBoolean((NBTTagCompound)nbt, (String)"tampered_with", (boolean)this.wasTamperedWith);
        this.isDepressed = NBTHelper.getBoolean((NBTTagCompound)nbt, (String)"depressed", (boolean)this.isDepressed);
        this.primaryColor = new Color(NBTHelper.getInteger((NBTTagCompound)nbt, (String)"primary_color", (int)0xFFFFFF));
        this.secondaryColor = new Color(NBTHelper.getInteger((NBTTagCompound)nbt, (String)"secondary_color", (int)0xFFFFFF));
        this.age = NBTHelper.getInteger((NBTTagCompound)nbt, (String)"age", (int)this.age);
        this.owner = NBTHelper.getUniqueId((NBTTagCompound)nbt, (String)"owner_id");
        if (nbt.func_74764_b("mana_capability")) {
            this.handler.deserializeNBT((NBTBase)NBTHelper.getCompoundTag((NBTTagCompound)nbt, (String)"mana_capability"));
        }
        this.infusedSpell.clear();
        NBTTagList list = NBTHelper.getTagList((NBTTagCompound)nbt, (String)"infused_spell", (int)10);
        if (list != null) {
            for (NBTBase base : list) {
                if (!(base instanceof NBTTagCompound)) continue;
                NBTTagCompound compound = (NBTTagCompound)base;
                SpellRing ring = SpellRing.deserializeRing(compound);
                this.infusedSpell.add(ring);
            }
        }
    }
}

