/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item;

import com.teamwizardry.librarianlib.features.base.item.IItemColorProvider;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.common.block.fluid.ModFluids;
import java.awt.Color;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function2;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface INacreProduct
extends IItemColorProvider {
    public static final float curveConst = 1.1864825f;

    default public void colorableOnUpdate(ItemStack stack, World world) {
        if (!world.field_72995_K) {
            if (!NBTHelper.hasNBTEntry((ItemStack)stack, (String)"rand")) {
                NBTHelper.setFloat((ItemStack)stack, (String)"rand", (float)((float)world.func_82737_E() / 140.0f % 140.0f));
            }
            if (!NBTHelper.hasNBTEntry((ItemStack)stack, (String)"purity")) {
                NBTHelper.setInt((ItemStack)stack, (String)"purity", (int)600);
                NBTHelper.setFloat((ItemStack)stack, (String)"purity_override", (float)1.0f);
            }
            if (!NBTHelper.getBoolean((ItemStack)stack, (String)"complete", (boolean)false)) {
                NBTHelper.setBoolean((ItemStack)stack, (String)"complete", (boolean)true);
            }
        }
    }

    default public void colorableOnEntityItemUpdate(EntityItem entityItem) {
        IBlockState state;
        if (entityItem.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = entityItem.func_92059_d();
        if (!NBTHelper.hasNBTEntry((ItemStack)stack, (String)"rand")) {
            NBTHelper.setFloat((ItemStack)stack, (String)"rand", (float)entityItem.field_70170_p.field_73012_v.nextFloat());
        }
        if ((state = entityItem.field_70170_p.func_180495_p(entityItem.func_180425_c())).func_177230_c() == ModFluids.NACRE.getActualBlock() && !NBTHelper.getBoolean((ItemStack)stack, (String)"complete", (boolean)false)) {
            int purity = NBTHelper.getInt((ItemStack)stack, (String)"purity", (int)0);
            purity = Math.min(purity + 1, 1200);
            NBTHelper.setInt((ItemStack)stack, (String)"purity", (int)purity);
        } else if (NBTHelper.getInt((ItemStack)stack, (String)"purity", (int)0) > 0) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"complete", (boolean)true);
        }
    }

    default public float getQuality(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        float override = NBTHelper.getFloat((ItemStack)stack, (String)"purity_override", (float)-1.0f);
        if (override > 0.0f) {
            return override;
        }
        float timeConstant = 600.0f;
        int purity = NBTHelper.getInt((ItemStack)stack, (String)"purity", (int)600);
        if (purity > 601) {
            return Math.max(0.0f, 2.0f - (float)purity / timeConstant);
        }
        if (purity < 599) {
            return Math.max(0.0f, (float)purity / timeConstant);
        }
        return 1.0f;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    default public Function2<ItemStack, Integer, Integer> getItemColorFunction() {
        return (stack, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            float rand = NBTHelper.getFloat((ItemStack)stack, (String)"rand", (float)-1.0f);
            float hue = rand < 0.0f ? (float)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 140.0f % 140.0f : rand;
            float pow = Math.min(1.0f, Math.max(0.0f, this.getQuality((ItemStack)stack)));
            float saturation = 1.1864825f * (1.0f - (float)Math.pow(Math.E, -pow));
            return Color.HSBtoRGB(hue, saturation, 1.0f);
        };
    }

    public static interface INacreDecayProduct
    extends INacreProduct {
        public static final double decayCurveDelimiter = 0.16666666666666666;

        @Override
        @Nullable
        @SideOnly(value=Side.CLIENT)
        default public Function2<ItemStack, Integer, Integer> getItemColorFunction() {
            return (stack, tintIndex) -> {
                if (tintIndex != 0) {
                    return 0xFFFFFF;
                }
                if (!stack.func_77942_o()) {
                    return Color.HSBtoRGB(MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 140.0f)), 0.75f, 1.0f);
                }
                long lastCast = NBTHelper.getLong((ItemStack)stack, (String)"last_cast", (long)-1L);
                int decayCooldown = NBTHelper.getInt((ItemStack)stack, (String)"last_cooldown", (int)-1);
                long tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
                long timeSinceCooldown = tick - lastCast;
                float decayStage = decayCooldown > 0 ? (float)timeSinceCooldown / (float)decayCooldown : 1.0f;
                float rand = NBTHelper.getFloat((ItemStack)stack, (String)"rand", (float)-1.0f);
                float hue = rand < 0.0f ? (float)tick / 140.0f % 140.0f : rand;
                float pow = Math.min(1.0f, Math.max(0.0f, this.getQuality((ItemStack)stack)));
                double decaySaturation = lastCast == -1L || decayCooldown <= 0 || decayStage >= 1.0f ? 1.0 : ((double)decayStage < 0.16666666666666666 ? Math.pow(Math.E, -15.0f * decayStage) : Math.pow(Math.E, 3.0f * decayStage - 3.0f));
                float saturation = 1.1864825f * (1.0f - (float)Math.pow(Math.E, -pow)) * (float)decaySaturation;
                return Color.HSBtoRGB(hue, saturation, 1.0f);
            };
        }
    }
}

