/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item.halo;

import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItemRegistry;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItemRenderers;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HaloInfusionItem {
    private final ItemStack stack;
    private final String nbtName;

    public HaloInfusionItem(ItemStack stack) {
        this.stack = stack;
        this.nbtName = stack.func_77977_a();
    }

    public HaloInfusionItem(Item item) {
        this(item, 1);
    }

    public HaloInfusionItem(Item item, int count) {
        this(new ItemStack(item, count));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public String getNbtName() {
        return this.nbtName;
    }

    @SideOnly(value=Side.CLIENT)
    public BiConsumer<Vec3d, World> getRenderer() {
        return HaloInfusionItemRenderers.getHaloRenderer(this);
    }

    @Nonnull
    public static HaloInfusionItem deserialize(String nbtName) {
        for (HaloInfusionItem haloInfusionItem : HaloInfusionItemRegistry.getItems()) {
            if (!haloInfusionItem.getNbtName().equalsIgnoreCase(nbtName)) continue;
            return haloInfusionItem;
        }
        return HaloInfusionItemRegistry.EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, Vec3d pos) {
        this.getRenderer().accept(pos, world);
    }
}

