/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.module;

import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideException;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideHandler;
import java.util.function.Consumer;

public class ModuleOverrideSuper {
    private final ModuleOverrideHandler.OverridePointer superPointer;
    private Exception occurredException;

    ModuleOverrideSuper(ModuleOverrideHandler.OverridePointer superPointer) {
        this.superPointer = superPointer;
    }

    public boolean hasSuper() {
        return this.superPointer != null;
    }

    public Object invoke(boolean throwRuntimeExceptionsImmediately, Object ... args) throws RuntimeException {
        try {
            return this.internalInvokeWithExceptions(args);
        }
        catch (Exception e) {
            if (throwRuntimeExceptionsImmediately && e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.occurredException = e;
            return null;
        }
    }

    public <ET extends Exception> void catchException(Class<ET> exceptionType, Consumer<ET> handler) {
        if (this.occurredException == null) {
            return;
        }
        try {
            if (exceptionType.isInstance(this.occurredException)) {
                handler.accept(this.occurredException);
            }
        }
        finally {
            this.occurredException = null;
        }
    }

    public void rethrowUncatched() throws RuntimeException, ModuleOverrideException {
        if (this.occurredException == null) {
            return;
        }
        try {
            if (this.occurredException instanceof RuntimeException) {
                throw (RuntimeException)this.occurredException;
            }
            throw new ModuleOverrideException("A checked exception has been thrown. See cause.", this.occurredException);
        }
        catch (Throwable throwable) {
            this.occurredException = null;
            throw throwable;
        }
    }

    private Object internalInvokeWithExceptions(Object ... args) throws Exception {
        if (this.superPointer == null) {
            throw new ModuleOverrideException("No super is existing.");
        }
        try {
            return this.superPointer.invoke(args);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new IllegalStateException("An unknown throwable occurred. Either Exception or Error is expected.", e);
        }
    }
}

