/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.structure;

import com.teamwizardry.librarianlib.features.structure.Structure;
import com.teamwizardry.librarianlib.features.structure.TemplateBlockAccess;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class WizardryStructure
extends Structure {
    private final WizardryStructureBlockAccess wizardryAccess;

    public WizardryStructure(@Nonnull ResourceLocation loc) {
        super(loc);
        this.wizardryAccess = new WizardryStructureBlockAccess(this.blockAccess);
    }

    public WizardryStructureBlockAccess getWizardryAccess() {
        return this.wizardryAccess;
    }

    public static class WizardryStructureBlockAccess
    implements IBlockAccess {
        private final TemplateBlockAccess originalAccess;

        WizardryStructureBlockAccess(TemplateBlockAccess originalAccess) {
            this.originalAccess = originalAccess;
        }

        @Nullable
        public TileEntity func_175625_s(@NotNull BlockPos pos) {
            return this.originalAccess.func_175625_s(pos);
        }

        public int func_175626_b(@NotNull BlockPos pos, int lightValue) {
            int sky = EnumSkyBlock.SKY.field_77198_c;
            int block = Math.max(EnumSkyBlock.BLOCK.field_77198_c, lightValue);
            return sky << 20 | block << 4;
        }

        @NotNull
        public IBlockState func_180495_p(@NotNull BlockPos pos) {
            return this.originalAccess.func_180495_p(pos);
        }

        public boolean func_175623_d(@NotNull BlockPos pos) {
            return this.originalAccess.func_175623_d(pos);
        }

        @NotNull
        public Biome func_180494_b(@NotNull BlockPos pos) {
            return this.originalAccess.func_180494_b(pos);
        }

        public int func_175627_a(@NotNull BlockPos pos, @NotNull EnumFacing direction) {
            return this.originalAccess.func_175627_a(pos, direction);
        }

        @NotNull
        public WorldType func_175624_G() {
            return this.originalAccess.func_175624_G();
        }

        public boolean isSideSolid(@NotNull BlockPos pos, @NotNull EnumFacing side, boolean _default) {
            return this.originalAccess.isSideSolid(pos, side, _default);
        }
    }
}

