/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.mojang.authlib.GameProfile;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class BlockUtils {
    private static final UUID ID = UUID.nameUUIDFromBytes("wizardry".getBytes(StandardCharsets.UTF_8));
    private static final GameProfile BREAKER = new GameProfile(ID, "Wizardry Block Breaker");
    private static final GameProfile PLACER = new GameProfile(ID, "Wizardry Block Placer");

    private BlockUtils() {
    }

    public static boolean isAnyAir(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == ModBlocks.FAKE_AIR;
    }

    public static boolean isAnyAir(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == ModBlocks.FAKE_AIR;
    }

    public static boolean isAnyAir(Block block) {
        return block == Blocks.field_150350_a || block == ModBlocks.FAKE_AIR;
    }

    public static EntityPlayerMP makePlacer(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            return (EntityPlayerMP)entity;
        }
        FakePlayer bro = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)PLACER);
        bro.func_174828_a(pos, 0.0f, -90.0f);
        bro.func_70095_a(true);
        return bro;
    }

    public static boolean placeBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayerMP player) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (!BlockUtils.hasEditPermission(pos, player)) {
            return false;
        }
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos), Blocks.field_150350_a.func_176223_P(), (EntityPlayer)player, player.func_184600_cs());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        world.func_175656_a(pos, state);
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public static boolean placeBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, @Nonnull ItemStack stack) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)PLACER);
        player.func_174828_a(pos, 0.0f, -90.0f);
        player.func_184611_a(EnumHand.MAIN_HAND, stack);
        player.func_70095_a(true);
        if (!BlockUtils.hasEditPermission(pos, (EntityPlayerMP)player)) {
            return false;
        }
        EnumActionResult result = player.field_71134_c.func_187251_a((EntityPlayer)player, world, stack, EnumHand.MAIN_HAND, pos, facing, 0.0f, 0.0f, 0.0f);
        return result != EnumActionResult.FAIL;
    }

    public static EntityPlayerMP makeBreaker(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            return (EntityPlayerMP)entity;
        }
        FakePlayer bro = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)BREAKER);
        bro.func_174828_a(pos, 0.0f, -90.0f);
        return bro;
    }

    public static boolean breakBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState oldState, @Nonnull EntityPlayerMP player) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (!(player instanceof FakePlayer) && !BlockUtils.hasEditPermission(pos, player)) {
            return false;
        }
        if (oldState == null) {
            oldState = world.func_180495_p(pos);
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, oldState, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        Block block = oldState.func_177230_c();
        if (!block.removedByPlayer(oldState, world, pos, (EntityPlayer)player, true)) {
            return false;
        }
        block.func_176206_d(world, pos, oldState);
        block.func_180657_a(world, (EntityPlayer)player, pos, oldState, tile, player.func_184614_ca());
        world.func_184138_a(pos, oldState, Blocks.field_150350_a.func_176223_P(), 3);
        return true;
    }

    public static boolean hasEditPermission(@Nonnull BlockPos pos, @Nonnull EntityPlayerMP player) {
        World world = player.func_130014_f_();
        if (!world.func_175660_a((EntityPlayer)player, pos)) {
            return false;
        }
        if (world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        return player.func_175142_cm();
    }

    public static Set<BlockPos> blocksInSquare(BlockPos center, EnumFacing.Axis axis, int maxBlocks, int maxRange, Predicate<BlockPos> ignore) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        if (ignore.test(center)) {
            return blocks;
        }
        blocks.add(center);
        if (blocks.size() >= maxBlocks) {
            return blocks;
        }
        LinkedList<BlockPos> blockQueue = new LinkedList<BlockPos>();
        blockQueue.add(center);
        while (!blockQueue.isEmpty()) {
            BlockPos pos = (BlockPos)blockQueue.remove();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos shift;
                if (facing.func_176740_k() == axis || (shift = pos.func_177972_a(facing)).func_177958_n() - center.func_177958_n() > maxRange || center.func_177958_n() - shift.func_177958_n() > maxRange || shift.func_177956_o() - center.func_177956_o() > maxRange || center.func_177956_o() - shift.func_177956_o() > maxRange || shift.func_177952_p() - center.func_177952_p() > maxRange || center.func_177952_p() - shift.func_177952_p() > maxRange || blocks.contains(shift) || ignore.test(shift)) continue;
                blocks.add(shift);
                blockQueue.add(shift);
                if (blocks.size() >= maxBlocks) break;
            }
            if (blocks.size() < maxBlocks) continue;
            break;
        }
        return blocks;
    }

    public static Set<BlockPos> blocksInSquare(BlockPos center, EnumFacing facing, int maxBlocks, int maxRange, Predicate<BlockPos> ignore) {
        return BlockUtils.blocksInSquare(center, facing.func_176740_k(), maxBlocks, maxRange, ignore);
    }

    public static <T extends TileEntity> T getTileEntity(IBlockAccess world, BlockPos pos, Class<T> clazz) {
        TileEntity te = world.func_175625_s(pos);
        if (!clazz.isInstance(te)) {
            return null;
        }
        return (T)te;
    }
}

