/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.wizardry.api.util.PosUtils;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderUtils {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final LightGatheringTransformer lightGatherer = new LightGatheringTransformer();

    private static void renderModel(IBakedModel model, int color, ItemStack stack) {
        RenderUtils.renderLitItem(Minecraft.func_71410_x().func_175599_af(), model, color, stack);
    }

    public static void renderItemStackWithOpacity(ItemStack stack, float opacity, @Nullable Runnable preDrawRunnable) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179098_w();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        if (preDrawRunnable != null) {
            preDrawRunnable.run();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (model.func_177556_c()) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                RenderUtils.renderModel(model, 0xFFFFFF | (int)(opacity * 255.0f) << 24, stack);
                if (stack.func_77962_s()) {
                    RenderUtils.renderEffect(model);
                }
            }
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-0.0f);
        GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    private static int getColorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == -1 || stack.func_190926_b()) {
            return -1;
        }
        int colorMultiplier = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, tintIndex);
        if (EntityRenderer.field_78517_a) {
            colorMultiplier = TextureUtil.func_177054_c((int)colorMultiplier);
        }
        return colorMultiplier;
    }

    private static void renderLitItem(RenderItem ri, IBakedModel model, int color, ItemStack stack) {
        ArrayList allquads = new ArrayList();
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            allquads.addAll(model.func_188616_a(null, enumfacing, 0L));
        }
        allquads.addAll(model.func_188616_a(null, null, 0L));
        if (allquads.isEmpty()) {
            return;
        }
        ArrayList<BakedQuad> segment = new ArrayList<BakedQuad>();
        int segmentBlockLight = -1;
        int segmentSkyLight = -1;
        int segmentColorMultiplier = color;
        boolean hasLighting = false;
        int prevTintIndex = -1;
        for (int i = 0; i < allquads.size(); ++i) {
            boolean colorDirty;
            BakedQuad q = (BakedQuad)allquads.get(i);
            int bl = 0;
            int sl = 0;
            if (q.getFormat() != DefaultVertexFormats.field_176599_b && q.getFormat().func_177347_a(1)) {
                q.pipe((IVertexConsumer)lightGatherer);
                if (lightGatherer.hasLighting()) {
                    bl = RenderUtils.lightGatherer.blockLight;
                    sl = RenderUtils.lightGatherer.skyLight;
                }
            }
            int colorMultiplier = segmentColorMultiplier;
            if (color == -1 && q.func_178212_b()) {
                int tintIndex = q.func_178211_c();
                if (prevTintIndex != tintIndex) {
                    colorMultiplier = RenderUtils.getColorMultiplier(stack, tintIndex);
                }
                prevTintIndex = tintIndex;
            } else {
                colorMultiplier = color;
                prevTintIndex = -1;
            }
            boolean lightingDirty = segmentBlockLight != bl || segmentSkyLight != sl;
            boolean bl2 = colorDirty = hasLighting && segmentColorMultiplier != colorMultiplier;
            if (lightingDirty || colorDirty) {
                if (i > 0) {
                    RenderUtils.drawSegment(color, stack, segment, segmentBlockLight, segmentSkyLight, segmentColorMultiplier, lightingDirty && (hasLighting || segment.size() < i), colorDirty);
                }
                segmentBlockLight = bl;
                segmentSkyLight = sl;
                segmentColorMultiplier = colorMultiplier;
                hasLighting = segmentBlockLight > 0 || segmentSkyLight > 0;
            }
            segment.add(q);
        }
        RenderUtils.drawSegment(color, stack, segment, segmentBlockLight, segmentSkyLight, segmentColorMultiplier, hasLighting || segment.size() < allquads.size(), false);
        if (hasLighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
            GL11.glMaterial((int)1032, (int)5632, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        }
    }

    private static void drawSegment(int baseColor, ItemStack stack, List<BakedQuad> segment, int bl, int sl, int tintColor, boolean updateLighting, boolean updateColor) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        float lastBl = OpenGlHelper.lastBrightnessX;
        float lastSl = OpenGlHelper.lastBrightnessY;
        if (updateLighting || updateColor) {
            float emissive = (float)Math.max(bl, sl) / 240.0f;
            float r = (float)(tintColor >>> 16 & 0xFF) / 255.0f;
            float g = (float)(tintColor >>> 8 & 0xFF) / 255.0f;
            float b = (float)(tintColor & 0xFF) / 255.0f;
            GL11.glMaterial((int)1032, (int)5632, (FloatBuffer)RenderHelper.func_74521_a((float)(emissive * r), (float)(emissive * g), (float)(emissive * b), (float)1.0f));
            if (updateLighting) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)Math.max((float)bl, lastBl), (float)Math.max((float)sl, lastSl));
            }
        }
        RenderUtils.renderQuads(bufferbuilder, segment, baseColor, stack);
        Tessellator.func_178181_a().func_78381_a();
        OpenGlHelper.lastBrightnessX = lastBl;
        OpenGlHelper.lastBrightnessY = lastSl;
        segment.clear();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        color &= 0xFF000000;
        boolean flag = !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color | 0xFFFFFF;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k &= 0xFFFFFF;
                k |= color;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    private static void renderEffect(IBakedModel model) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtils.renderModel(model, -8372020, ItemStack.field_190927_a);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtils.renderModel(model, -8372020, ItemStack.field_190927_a);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)0.125f);
    }

    public static void drawCubeOutline(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        int color = Color.HSBtoRGB((float)(ClientTickHandler.getTicks() % 200) / 200.0f, 0.6f, 1.0f);
        Color colorRGB = new Color(color);
        RenderUtils.drawCubeOutline(world, pos, state, colorRGB);
    }

    public static void drawCubeOutline(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179142_g();
        GlStateManager.func_179140_f();
        GlStateManager.func_187441_d((float)0.5f);
        RenderUtils.bufferBlockOutline(state.func_185918_c(world, pos), color);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public static void drawCircle(@Nonnull Vec3d pos, double radius, boolean flattenToScreen, boolean enableDepth) {
        int color = MathHelper.func_181758_c((float)((float)(ClientTickHandler.getTicks() % 200) / 200.0f), (float)0.6f, (float)1.0f);
        Color colorRGB = new Color(color);
        RenderUtils.drawCircle(pos, radius, flattenToScreen, enableDepth, colorRGB);
    }

    public static void drawCircle(@Nonnull Vec3d pos, double radius, boolean flattenToScreen, boolean enableDepth, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
        if (flattenToScreen) {
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2 ? -1 : 1) * Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.02, (double)-0.02, (double)0.0);
        }
        if (enableDepth) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179142_g();
        GlStateManager.func_179137_b((double)0.0, (double)0.01, (double)0.0);
        GlStateManager.func_187441_d((float)0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i <= 360; ++i) {
            double x = radius * (double)MathHelper.func_76134_b((float)((float)((double)i / 360.0 * Math.PI * 2.0)));
            double z = radius * (double)MathHelper.func_76126_a((float)((float)((double)i / 360.0 * Math.PI * 2.0)));
            if (flattenToScreen) {
                bb.func_181662_b(x, z, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                continue;
            }
            bb.func_181662_b(x, 0.0, z).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179119_h();
        GlStateManager.func_179121_F();
    }

    public static void drawFaceOutline(@Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        int color = Color.HSBtoRGB((float)(ClientTickHandler.getTicks() % 200) / 200.0f, 0.6f, 1.0f);
        Color colorRGB = new Color(color);
        RenderUtils.drawFaceOutline(pos, facing, colorRGB);
    }

    public static void drawFaceOutline(@Nonnull BlockPos pos, @Nonnull EnumFacing facing, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179142_g();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Vec3d directionOffsetVec = new Vec3d(facing.func_176730_m()).func_186678_a(0.5);
        Vec3d adjPos = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5).func_178787_e(directionOffsetVec);
        GlStateManager.func_187441_d((float)0.5f);
        for (EnumFacing facing1 : PosUtils.getPerpendicularFacings(facing)) {
            for (EnumFacing facing2 : PosUtils.getPerpendicularFacings(facing)) {
                if (facing1 == facing2 || facing1.func_176734_d() == facing2 || facing2.func_176734_d() == facing1) continue;
                Vec3d p1 = new Vec3d(facing1.func_176730_m()).func_186678_a(0.5);
                Vec3d p2 = new Vec3d(facing2.func_176730_m()).func_186678_a(0.5);
                Vec3d edge = adjPos.func_178787_e(p1.func_178787_e(p2));
                tessellator.func_178180_c().func_181662_b(edge.field_72450_a, edge.field_72448_b, edge.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179119_h();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public static void bufferBlockOutline(AxisAlignedBB aabb, Color color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        double ix = aabb.field_72340_a;
        double iy = aabb.field_72338_b;
        double iz = aabb.field_72339_c;
        double ax = aabb.field_72336_d;
        double ay = aabb.field_72337_e;
        double az = aabb.field_72334_f;
        tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181706_f);
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_78381_a();
    }

    private static class LightGatheringTransformer
    extends QuadGatheringTransformer {
        private static final VertexFormat FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p);
        int blockLight;
        int skyLight;

        private LightGatheringTransformer() {
            this.setVertexFormat(FORMAT);
        }

        boolean hasLighting() {
            return this.dataLength[1] >= 2;
        }

        protected void processQuad() {
            this.blockLight = 0;
            this.skyLight = 0;
            for (int i = 0; i < 4; ++i) {
                this.blockLight += (int)(this.quadData[1][i][0] * 65535.0f / 32.0f);
                this.skyLight += (int)(this.quadData[1][i][1] * 65535.0f / 32.0f);
            }
            this.blockLight *= 4;
            this.skyLight *= 4;
        }

        public void setQuadTint(int tint) {
        }

        public void setQuadOrientation(@NotNull EnumFacing orientation) {
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        public void setTexture(@NotNull TextureAtlasSprite texture) {
        }
    }
}

