/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpLine;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.capability.player.miscdata.IMiscCapability;
import com.teamwizardry.wizardry.api.capability.player.miscdata.MiscCapabilityProvider;
import com.teamwizardry.wizardry.api.entity.fairy.FairyData;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.init.ModItems;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class FairyBindingRenderer {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (event.side == Side.SERVER) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != ModItems.FAIRY_BELL) {
            return;
        }
        for (EntityFairy entityFairy : world.func_175644_a(EntityFairy.class, input -> {
            if (input == null) {
                return false;
            }
            FairyData dataFairy = input.getDataFairy();
            if (dataFairy == null) {
                return false;
            }
            return dataFairy.isDepressed;
        })) {
            Vec3d look = entityFairy.getLookTarget();
            if (look == null) continue;
            ParticleBuilder glitter = new ParticleBuilder(10);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 1.0f));
            glitter.setColor(Color.ORANGE);
            glitter.setCollision(true);
            glitter.disableRandom();
            glitter.disableMotionCalculation();
            if (ClientTickHandler.getTicks() % 10 != 0) continue;
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)entityFairy.func_174791_d().func_72441_c(0.0, (double)entityFairy.field_70131_O, 0.0)), (int)1, (int)0, (aFloat, particleBuilder) -> {
                particleBuilder.setScaleFunction((InterpFunction)new InterpFloatInOut(0.0f, 1.0f));
                particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 1.0f));
                particleBuilder.setScale(RandUtil.nextFloat(0.2f, 0.5f));
                particleBuilder.setLifetime(RandUtil.nextInt(10, 20));
                particleBuilder.setPositionFunction((InterpFunction)new InterpLine(Vec3d.field_186680_a, look));
            });
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render(RenderWorldLastEvent event) {
        EntityFairy fairy;
        FairyData data;
        Entity entityHit;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71476_x == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != ModItems.FAIRY_BELL) {
            return;
        }
        if (Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY && (entityHit = Minecraft.func_71410_x().field_71476_x.field_72308_g) instanceof EntityFairy && (data = (fairy = (EntityFairy)entityHit).getDataFairy()) != null && data.isDepressed) {
            double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)Minecraft.func_71410_x().field_71439_g);
            if (cap == null) {
                return;
            }
            UUID uuid = cap.getSelectedFairyUUID();
            if (uuid != null && uuid.equals(fairy.func_110124_au())) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
                RenderUtils.drawCircle(fairy.func_174791_d().func_72441_c(0.0, (double)fairy.field_70131_O, 0.0), 0.3, true, false, Color.RED);
                GlStateManager.func_179121_F();
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
                RenderUtils.drawCircle(fairy.func_174791_d().func_72441_c(0.0, (double)fairy.field_70131_O, 0.0), (Math.sin((float)ClientTickHandler.getTicks() / 5.0f) + 2.5) / 10.0, true, false);
                GlStateManager.func_179121_F();
            }
        }
        for (EntityFairy entityFairy : world.func_175644_a(EntityFairy.class, input -> {
            if (input == null) {
                return false;
            }
            FairyData dataFairy = input.getDataFairy();
            if (dataFairy == null) {
                return false;
            }
            return dataFairy.isDepressed;
        })) {
            Color c;
            UUID uuid;
            FairyData dataFairy = entityFairy.getDataFairy();
            if (dataFairy == null) {
                return;
            }
            IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)Minecraft.func_71410_x().field_71439_g);
            if (cap == null) {
                return;
            }
            double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder bb = tess.func_178180_c();
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            RenderUtils.drawCircle(entityFairy.func_174791_d().func_72441_c(0.0, (double)entityFairy.field_70131_O, 0.0), 0.25, true, false, Color.YELLOW);
            GlStateManager.func_179121_F();
            Vec3d lookTarget = entityFairy.getLookTarget();
            Vec3d fairyPos = entityFairy.func_174791_d().func_72441_c(0.0, (double)entityFairy.field_70131_O, 0.0);
            if (lookTarget != null) {
                Vec3d to = fairyPos.func_178787_e(lookTarget);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
                RenderUtils.drawCircle(to, 0.1, true, false, Color.ORANGE);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179112_b((int)770, (int)1);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179142_g();
                GlStateManager.func_179126_j();
                bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                Color c2 = Color.ORANGE;
                bb.func_181662_b(to.field_72450_a, to.field_72448_b, to.field_72449_c).func_181669_b(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
                bb.func_181662_b(fairyPos.field_72450_a, fairyPos.field_72448_b, fairyPos.field_72449_c).func_181669_b(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
            }
            if ((uuid = cap.getSelectedFairyUUID()) == null || !uuid.equals(entityFairy.func_110124_au())) continue;
            boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
            if (!movingMode) {
                Vec3d hitVec = Minecraft.func_71410_x().field_71476_x.field_72307_f;
                Vec3d subtract = hitVec.func_178788_d(fairyPos);
                double length = subtract.func_72433_c();
                hitVec = entityFairy.func_174791_d().func_72441_c(0.0, (double)entityFairy.field_70131_O, 0.0).func_178787_e(subtract.func_72432_b().func_186678_a(MathHelper.func_151237_a((double)length, (double)-3.0, (double)3.0)));
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
                RenderUtils.drawCircle(hitVec, 0.2, true, false, Color.CYAN);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179112_b((int)770, (int)1);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179142_g();
                GlStateManager.func_179126_j();
                bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                c = Color.GREEN;
                bb.func_181662_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
                bb.func_181662_b(fairyPos.field_72450_a, fairyPos.field_72448_b, fairyPos.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
                continue;
            }
            if (Minecraft.func_71410_x().field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            BlockPos target = Minecraft.func_71410_x().field_71476_x.func_178782_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            RenderUtils.drawCubeOutline(entityFairy.field_70170_p, target, entityFairy.field_70170_p.func_180495_p(target), Color.CYAN);
            GlStateManager.func_179121_F();
            Vec3d tar = new Vec3d((Vec3i)target).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(Minecraft.func_71410_x().field_71476_x.field_178784_b.func_176730_m()));
            PathNavigate navigateFlying = entityFairy.func_70661_as();
            Path path = navigateFlying.func_75488_a(tar.field_72450_a, tar.field_72448_b, tar.field_72449_c);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            RenderUtils.drawCircle(tar, 0.25, true, false, Color.CYAN);
            GlStateManager.func_179121_F();
            if (path == null) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179142_g();
            GlStateManager.func_179097_i();
            bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            c = Color.GREEN;
            Vec3d lastPoint = null;
            Vec3d center = new Vec3d(entityFairy.field_70165_t, entityFairy.field_70163_u + (double)entityFairy.field_70131_O / 2.0, entityFairy.field_70161_v);
            bb.func_181662_b(center.field_72450_a, center.field_72448_b, center.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
            for (int i = 0; i < path.func_75874_d(); ++i) {
                Vec3d vec = path.func_75881_a((Entity)entityFairy, i);
                if (lastPoint != null) {
                    if (i >= path.func_75874_d() - 1) continue;
                    Vec3d from = path.func_75881_a((Entity)entityFairy, i - 1);
                    from = from.func_178788_d(from.func_178788_d(vec).func_186678_a(0.5));
                    Vec3d to = path.func_75881_a((Entity)entityFairy, i + 1);
                    to = to.func_178788_d(to.func_178788_d(vec).func_186678_a(0.5));
                    Vec3d fromControl = vec.func_178788_d(from).func_72432_b().func_186678_a(0.4);
                    Vec3d toControl = vec.func_178788_d(to).func_72432_b().func_186678_a(0.4);
                    InterpBezier3D bezier = new InterpBezier3D(from, to, fromControl, toControl);
                    for (Vec3d dot : bezier.list(20)) {
                        bb.func_181662_b(dot.field_72450_a, dot.field_72448_b, dot.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
                        lastPoint = dot;
                    }
                    continue;
                }
                bb.func_181662_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
                lastPoint = vec;
            }
            bb.func_181662_b(tar.field_72450_a, tar.field_72448_b, tar.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    private static void light(World world, Vec3d pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.disableRandom();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (i, build) -> {
            build.setScale(0.25f);
            build.setColor(color);
        });
    }
}

