/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.cosmetics;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.ClientConfigValues;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.util.RandUtilSeed;
import com.teamwizardry.wizardry.common.module.effects.vanish.VanishTracker;
import com.teamwizardry.wizardry.init.ModItems;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class CapeHandler {
    private final LoadingCache<EntityPlayer, RenderCape> capes = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(10L, TimeUnit.SECONDS).ticker(new Ticker(){

        public long read() {
            return Minecraft.func_71386_F();
        }
    }).build(CacheLoader.from(() -> RenderCape.access$3800()));

    private CapeHandler() {
    }

    public static CapeHandler instance() {
        return Holder.INSTANCE;
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Post event) {
        RenderCape cape;
        EntityPlayer player = event.getEntityPlayer();
        float delta = event.getPartialRenderTick();
        if (ClientConfigValues.renderCape && !player.func_82150_aj() && !VanishTracker.isVanished((Entity)player) && !player.func_184613_cA() && !player.func_70608_bn() && delta != 1.0f && (cape = this.getCape(player)).isPresent(player)) {
            cape.render(player, player.field_70165_t - cape.posX - TileEntityRendererDispatcher.field_147554_b, player.field_70163_u - cape.posY - TileEntityRendererDispatcher.field_147555_c, player.field_70161_v - cape.posZ - TileEntityRendererDispatcher.field_147552_d, delta);
        }
    }

    private RenderCape getCape(EntityPlayer player) {
        return (RenderCape)this.capes.getUnchecked((Object)player);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END && (world = FMLClientHandler.instance().getWorldClient()) != null) {
            for (EntityPlayer player : world.field_73010_i) {
                this.getCape(player).update(player);
            }
        }
    }

    private static final class RenderCape {
        private static final int PLAYER_SKIP_RANGE = 16;
        private static final int FLUID_CACHE_CLEAR_RATE = 4;
        private static final int FLUID_CACHE_CLEAR_SIZE = 6;
        private static final int ITERATIONS = 11;
        private static final float DELTA_TIME = 0.0052f;
        private static final float GRAVITY = -2800.0f;
        private static final float FLUID_FORCE = -100.0f;
        private static final int HEIGHT = 8;
        private static final int WIDTH = 4;
        private final ImmutableList<Point> points;
        private final ImmutableList<Quad> quads;
        private final Long2BooleanMap fluidCache = new Long2BooleanOpenHashMap(10);
        private final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
        private double posX;
        private double posY;
        private double posZ;

        private RenderCape(ImmutableList<Point> points, ImmutableList<Quad> quads) {
            this.points = points;
            this.quads = quads;
        }

        private static RenderCape create() {
            return RenderCape.create(4, 8);
        }

        private static RenderCape create(int width, int height) {
            ArrayList points = Lists.newArrayList();
            ImmutableList.Builder quads = ImmutableList.builder();
            float scale = 0.125f;
            int columns = width + 1;
            PlayerCollisionResolver collision = new PlayerCollisionResolver();
            for (int y = 0; y <= height; ++y) {
                for (int x = 0; x <= width; ++x) {
                    ImmutableList.Builder res = ImmutableList.builder();
                    float mass = 1.0f;
                    if (y == 0 || y == 1 && (x == 0 || x == width)) {
                        mass = 0.0f;
                        res.add((Object)new PlayerPinResolver(-((float)x - (float)width * 0.5f) * scale, (float)(-y) * scale));
                    }
                    if (y > 0 || x > 0) {
                        float t = (float)y / (float)height;
                        mass = 1.0f - t * 0.1f;
                        LinkResolver link = new LinkResolver();
                        if (y > 0) {
                            link.attach((Point)points.get(x + (y - 1) * columns), scale, 2.0f + -0.049999952f * t);
                        }
                        if (x > 0) {
                            link.attach((Point)points.get(points.size() - 1), scale * (1.0f + (float)y / (float)height * 0.1f), 1.0f);
                        }
                        res.add((Object)link);
                    }
                    res.add((Object)collision);
                    points.add(new Point(-((float)x - (float)width * 0.5f) * scale, (float)(-y) * scale, 0.0f, mass, res.build()));
                    if (x <= 0 || y <= 0) continue;
                    int p00x = x - 1;
                    int p00y = y - 1;
                    int p01x = x - 1;
                    int p01y = y;
                    int p11x = x;
                    int p10y = y;
                    int p10x = x;
                    int p11y = y - 1;
                    Quad.Vertex v00 = Quad.vert((Point)points.get(p00x + p00y * columns), p00x, p00y, width, height);
                    Quad.Vertex v01 = Quad.vert((Point)points.get(p01x + p01y * columns), p01x, p01y, width, height);
                    Quad.Vertex v11 = Quad.vert((Point)points.get(p11x + p10y * columns), p11x, p10y, width, height);
                    Quad.Vertex v10 = Quad.vert((Point)points.get(p10x + p11y * columns), p10x, p11y, width, height);
                    quads.add((Object)new Quad(v00, v01, v11, v10));
                }
            }
            points.sort((a, b) -> Double.compare(MathHelper.func_76129_c((float)(((Point)b).posX * ((Point)b).posX + ((Point)b).posY + ((Point)b).posY)), MathHelper.func_76129_c((float)(((Point)a).posX * ((Point)a).posX + ((Point)a).posY + ((Point)a).posY))));
            return new RenderCape((ImmutableList<Point>)ImmutableList.copyOf((Collection)points), (ImmutableList<Quad>)quads.build());
        }

        private boolean isPresent(EntityPlayer player) {
            return !BaublesSupport.getItem((EntityLivingBase)player, ModItems.CAPE).func_190926_b();
        }

        private void update(EntityPlayer player) {
            if (this.isPresent(player)) {
                this.updatePlayerPos(player);
                this.updatePoints(player);
                this.updateFluidCache(player);
            }
        }

        private void updatePlayerPos(EntityPlayer player) {
            double dx = player.field_70165_t - this.posX;
            double dy = player.field_70163_u - this.posY;
            double dz = player.field_70161_v - this.posZ;
            double dist = dx * dx + dy * dy + dz * dz;
            if (dist > 16.0) {
                UnmodifiableIterator unmodifiableIterator = this.points.iterator();
                while (unmodifiableIterator.hasNext()) {
                    Point point;
                    Point point2 = point = (Point)unmodifiableIterator.next();
                    point2.posX = (float)((double)point2.posX + dx);
                    point2 = point;
                    point2.posY = (float)((double)point2.posY + dy);
                    point2 = point;
                    point2.posZ = (float)((double)point2.posZ + dz);
                    point2 = point;
                    point2.prevPosX = (float)((double)point2.prevPosX + dx);
                    point2 = point;
                    point2.prevPosY = (float)((double)point2.prevPosY + dy);
                    point2 = point;
                    point2.prevPosZ = (float)((double)point2.prevPosZ + dz);
                }
            }
            this.posX = player.field_70165_t;
            this.posY = player.field_70163_u;
            this.posZ = player.field_70161_v;
        }

        private void updatePoints(EntityPlayer player) {
            for (Point point : this.points) {
                point.update(player.field_70170_p, this, 0.0052f);
            }
            for (int i = 0; i < 11; ++i) {
                int j = this.points.size();
                while (j-- > 0) {
                    ((Point)this.points.get(j)).resolveConstraints(player);
                }
            }
        }

        private void updateFluidCache(EntityPlayer player) {
            if (player.field_70173_aa % 4 == 0 && this.fluidCache.size() > 6) {
                this.fluidCache.clear();
            }
        }

        private boolean isFluid(World world, float x, float y, float z) {
            long key = this.scratchPos.func_189532_c((double)x, (double)y, (double)z).func_177986_g();
            if (this.fluidCache.containsKey(key)) {
                return this.fluidCache.get(key);
            }
            boolean isFluid = this.isFluid(world.func_180495_p((BlockPos)this.scratchPos));
            this.fluidCache.put(key, isFluid);
            return isFluid;
        }

        private boolean isFluid(IBlockState state) {
            return state.func_177230_c() instanceof IFluidBlock || state.func_177230_c() instanceof BlockLiquid;
        }

        private void render(EntityPlayer player, double x, double y, double z, float delta) {
            ResourceLocation fallBackCape;
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder buf = tes.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            buf.func_178969_c(x, y, z);
            for (Quad quad : this.quads) {
                Quad.Vertex v00 = quad.getV00();
                Quad.Vertex v01 = quad.getV01();
                Quad.Vertex v11 = quad.getV11();
                Quad.Vertex v10 = quad.getV10();
                float v00x = v00.getX(delta);
                float v00y = v00.getY(delta);
                float v00z = v00.getZ(delta);
                float v01x = v01.getX(delta);
                float v01y = v01.getY(delta);
                float v01z = v01.getZ(delta);
                float v11x = v11.getX(delta);
                float v11y = v11.getY(delta);
                float v11z = v11.getZ(delta);
                float v10x = v10.getX(delta);
                float v10y = v10.getY(delta);
                float v10z = v10.getZ(delta);
                float nx = (v11y - v00y) * (v10z - v01z) - (v11z - v00z) * (v10y - v01y);
                float ny = (v10x - v01x) * (v11z - v00z) - (v10z - v01z) * (v11x - v00x);
                float nz = (v11x - v00x) * (v10y - v01y) - (v11y - v00y) * (v10x - v01x);
                float len = MathHelper.func_76129_c((float)(nx * nx + ny * ny + nz * nz));
                buf.func_181662_b((double)v00x, (double)v00y, (double)v00z).func_187315_a(v00.getU(), v00.getV()).func_181663_c(nx /= len, ny /= len, nz /= len).func_181675_d();
                buf.func_181662_b((double)v01x, (double)v01y, (double)v01z).func_187315_a(v01.getU(), v01.getV()).func_181663_c(nx, ny, nz).func_181675_d();
                buf.func_181662_b((double)v11x, (double)v11y, (double)v11z).func_187315_a(v11.getU(), v11.getV()).func_181663_c(nx, ny, nz).func_181675_d();
                buf.func_181662_b((double)v10x, (double)v10y, (double)v10z).func_187315_a(v10.getU(), v10.getV()).func_181663_c(nx, ny, nz).func_181675_d();
            }
            buf.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            ItemStack stack = BaublesSupport.getItem((EntityLivingBase)player, ModItems.CAPE);
            UUID uuid = NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid");
            if (uuid != null) {
                RandUtilSeed seed = new RandUtilSeed(uuid.hashCode());
                fallBackCape = new ResourceLocation("wizardry", "textures/capes/cape_normal_" + seed.nextInt(1, 4) + ".png");
            } else {
                fallBackCape = new ResourceLocation("wizardry", "textures/capes/cape_normal_3.png");
            }
            String capeName = "cape_" + player.func_110124_au().toString().replace("-", "");
            ResourceLocation loc = new ResourceLocation("wizardry", "capes/" + capeName);
            ResourceLocation finalFallBackCape = fallBackCape;
            Minecraft.func_71410_x().func_152344_a(() -> {
                ITextureObject itextureobject = Minecraft.func_71410_x().func_110434_K().func_110581_b(loc);
                if (itextureobject == null) {
                    ThreadDownloadImageData threaddownloadimagedata = new ThreadDownloadImageData(null, "https://raw.githubusercontent.com/TeamWizardry/Wizardry/master/capes/" + capeName + ".png", finalFallBackCape, null);
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(loc, (ITextureObject)threaddownloadimagedata);
                }
            });
            Minecraft.func_71410_x().func_110434_K().func_110577_a(loc);
            tes.func_78381_a();
            GlStateManager.func_179089_o();
        }

        private static final class PlayerCollisionResolver
        extends PlayerResolver {
            private PlayerCollisionResolver() {
            }

            @Override
            public void resolve(EntityPlayer player, Point point) {
                float yaw = (float)(Math.toRadians(player.field_70761_aq) - 1.5707963267948966);
                float dx = MathHelper.func_76134_b((float)yaw);
                float dz = MathHelper.func_76126_a((float)yaw);
                float px = (float)player.field_70165_t;
                float py = (float)player.field_70163_u + 0.56f;
                float pz = (float)player.field_70161_v;
                if (player.func_70093_af()) {
                    float dist = this.getBack(player, 0.45f);
                    float backX = px + dx * dist;
                    float backZ = pz + dz * dist;
                    float dy = 0.52f;
                    float len = MathHelper.func_76129_c((float)(1.0f + dy * dy));
                    float rz = (point.posX - (float)player.field_70165_t) * (dx /= len) + (point.posZ - (float)player.field_70161_v) * (dz /= len);
                    float a = (MathHelper.func_76131_a((float)(-rz), (float)-0.5f, (float)-0.4f) + 0.5f) / 0.1f;
                    this.collideWithPlane(point, backX, py, backZ, dx, dy /= len, dz, a);
                } else {
                    float rx = (point.posX - (float)player.field_70165_t) * MathHelper.func_76134_b((float)(yaw + 1.5707964f)) + (point.posZ - (float)player.field_70161_v) * MathHelper.func_76126_a((float)(yaw + 1.5707964f));
                    float a = 1.0f - (MathHelper.func_76131_a((float)Math.abs(rx), (float)0.24f, (float)0.36f) - 0.24f) / 0.12000002f;
                    float dist = this.getBack(player, 0.14f);
                    this.collideWithPlane(point, px + dx * dist, py, pz + dz * dist, dx, 0.0f, dz, a);
                }
            }

            private float getDistToPlane(Point point, float px, float py, float pz, float nx, float ny, float nz) {
                return nx * (point.posX - px) + ny * (point.posY - py) + nz * (point.posZ - pz);
            }

            private void collideWithPlane(Point point, float px, float py, float pz, float nx, float ny, float nz, float amount) {
                float d = this.getDistToPlane(point, px, py, pz, nx, ny, nz);
                if (d < 0.0f) {
                    Point point2 = point;
                    point2.posX = point2.posX - nx * d * amount;
                    point2 = point;
                    point2.posY = point2.posY - ny * d * amount;
                    point2 = point;
                    point2.posZ = point2.posZ - nz * d * amount;
                }
            }
        }

        private static final class LinkResolver
        implements ConstraintResolver {
            private final List<Link> constraints = Lists.newArrayList();

            private LinkResolver() {
            }

            private LinkResolver attach(Point point, float length, float strength) {
                this.constraints.add(new Link(point, length, strength));
                return this;
            }

            @Override
            public void resolve(EntityPlayer player, Point point) {
                int i = this.constraints.size();
                while (i-- > 0) {
                    this.constraints.get(i).resolve(point);
                }
            }

            private static final class Link {
                private static final float EPSILON = 1.0E-6f;
                private final Point dest;
                private final float length;
                private final float strength;

                private Link(Point dest, float length, float strength) {
                    this.dest = dest;
                    this.length = length;
                    this.strength = strength;
                }

                private void resolve(Point point) {
                    float dz;
                    float dy;
                    float dx = point.posX - this.dest.posX;
                    float dist = MathHelper.func_76129_c((float)(dx * dx + (dy = point.posY - this.dest.posY) * dy + (dz = point.posZ - this.dest.posZ) * dz));
                    float d = dist * (point.invMass + this.dest.invMass);
                    float diff = d < 1.0E-6f ? this.length / 2.0f : (dist - this.length) / d;
                    float px = dx * diff * this.strength;
                    float py = dy * diff * this.strength;
                    float pz = dz * diff * this.strength;
                    Point point2 = point;
                    point2.posX = point2.posX - px * point.invMass;
                    point2 = point;
                    point2.posY = point2.posY - py * point.invMass;
                    point2 = point;
                    point2.posZ = point2.posZ - pz * point.invMass;
                    point2 = this.dest;
                    point2.posX = point2.posX + px * this.dest.invMass;
                    point2 = this.dest;
                    point2.posY = point2.posY + py * this.dest.invMass;
                    point2 = this.dest;
                    point2.posZ = point2.posZ + pz * this.dest.invMass;
                }
            }
        }

        private static final class PlayerPinResolver
        extends PlayerResolver {
            private final float x;
            private final float y;

            private PlayerPinResolver(float x, float y) {
                this.x = x;
                this.y = y;
            }

            @Override
            public void resolve(EntityPlayer player, Point point) {
                float back;
                float height;
                float yaw = (float)Math.toRadians(player.field_70761_aq);
                if (player.func_70093_af()) {
                    height = 1.15f;
                    back = this.getBack(player, 0.135f);
                } else {
                    height = 1.38f;
                    back = this.getBack(player, 0.14f);
                }
                float vx = MathHelper.func_76134_b((float)yaw) * this.x + MathHelper.func_76134_b((float)(yaw - 1.5707964f)) * back;
                float vz = MathHelper.func_76126_a((float)yaw) * this.x + MathHelper.func_76126_a((float)(yaw - 1.5707964f)) * back;
                point.posX = (float)player.field_70165_t + vx;
                point.posY = (float)player.field_70163_u + height + this.y;
                point.posZ = (float)player.field_70161_v + vz;
            }
        }

        private static abstract class PlayerResolver
        implements ConstraintResolver {
            private PlayerResolver() {
            }

            final float getBack(EntityPlayer player, float offset) {
                if (player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                    return offset;
                }
                return offset + 0.075f;
            }
        }

        private static final class Point {
            private final ImmutableList<ConstraintResolver> constraintResolvers;
            private float prevPosX;
            private float prevPosY;
            private float prevPosZ;
            private float posX;
            private float posY;
            private float posZ;
            private float motionX;
            private float motionY;
            private float motionZ;
            private float invMass;

            private Point(float posX, float posY, float posZ, float invMass, ImmutableList<ConstraintResolver> constraintResolvers) {
                this.posX = posX;
                this.posY = posY;
                this.posZ = posZ;
                this.invMass = invMass;
                this.constraintResolvers = constraintResolvers;
            }

            private void applyForce(float x, float y, float z) {
                this.motionX += x;
                this.motionY += y;
                this.motionZ += z;
            }

            private void update(World world, RenderCape cape, float delta) {
                this.applyForce(0.0f, cape.isFluid(world, this.posX, this.posY, this.posZ) ? -100.0f : -2800.0f, 0.0f);
                float x = this.posX + (this.posX - this.prevPosX) * 0.75f + this.motionX * 0.5f * (delta * delta);
                float y = this.posY + (this.posY - this.prevPosY) * 0.75f + this.motionY * 0.5f * (delta * delta);
                float z = this.posZ + (this.posZ - this.prevPosZ) * 0.75f + this.motionZ * 0.5f * (delta * delta);
                this.prevPosX = this.posX;
                this.prevPosY = this.posY;
                this.prevPosZ = this.posZ;
                this.posX = x;
                this.posY = y;
                this.posZ = z;
                this.motionZ = 0.0f;
                this.motionY = 0.0f;
                this.motionX = 0.0f;
            }

            private void resolveConstraints(EntityPlayer player) {
                for (ConstraintResolver r : this.constraintResolvers) {
                    r.resolve(player, this);
                }
            }
        }

        private static final class Quad {
            private final Vertex v00;
            private final Vertex v01;
            private final Vertex v11;
            private final Vertex v10;

            private Quad(Vertex v00, Vertex v01, Vertex v11, Vertex v10) {
                this.v00 = v00;
                this.v01 = v01;
                this.v11 = v11;
                this.v10 = v10;
            }

            private static Vertex vert(Point point, int u, int v, int width, int height) {
                return new Vertex(point, (float)u / (float)width, (float)v / (float)height);
            }

            private Vertex getV00() {
                return this.v00;
            }

            private Vertex getV01() {
                return this.v01;
            }

            private Vertex getV11() {
                return this.v11;
            }

            private Vertex getV10() {
                return this.v10;
            }

            private static final class Vertex {
                private final Point point;
                private final double u;
                private final double v;

                private Vertex(Point point, double u, double v) {
                    this.point = point;
                    this.u = u;
                    this.v = v;
                }

                private float getX(float delta) {
                    return this.point.prevPosX + (this.point.posX - this.point.prevPosX) * delta;
                }

                private float getY(float delta) {
                    return this.point.prevPosY + (this.point.posY - this.point.prevPosY) * delta;
                }

                private float getZ(float delta) {
                    return this.point.prevPosZ + (this.point.posZ - this.point.prevPosZ) * delta;
                }

                private double getU() {
                    return this.u;
                }

                private double getV() {
                    return this.v;
                }
            }
        }

        private static interface ConstraintResolver {
            public void resolve(EntityPlayer var1, Point var2);
        }
    }

    private static final class Holder {
        private static final CapeHandler INSTANCE = new CapeHandler();

        private Holder() {
        }
    }
}

