/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.book;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.features.gui.components.ComponentStack;
import com.teamwizardry.librarianlib.features.gui.components.ComponentText;
import com.teamwizardry.librarianlib.features.gui.components.ComponentVoid;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.Bookmark;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.PaginationContext;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.sprite.ISprite;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.client.gui.book.GuiBook;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentSpellRecipe
implements IBookElement {
    private final Book book;

    public ComponentSpellRecipe(Book book) {
        this.book = book;
    }

    @NotNull
    public Book getBookParent() {
        return this.book;
    }

    @NotNull
    public List<Bookmark> addAllBookmarks(@Nullable List<? extends Bookmark> list) {
        return IBookElement.DefaultImpls.addAllBookmarks((IBookElement)this, list);
    }

    @NotNull
    public List<PaginationContext> createComponents(@NotNull IBookGui book) {
        return ComponentSpellRecipe.components((GuiBook)book);
    }

    public static List<PaginationContext> components(GuiBook book) {
        ArrayList contexts = Lists.newArrayList();
        if (book.getBookItemStack().func_190926_b()) {
            return contexts;
        }
        ItemStack bookStack = book.getBookItemStack();
        if (!NBTHelper.getBoolean((ItemStack)bookStack, (String)"has_spell", (boolean)false)) {
            return contexts;
        }
        NBTTagList moduleList = NBTHelper.getList((ItemStack)bookStack, (String)"spellData", (int)8);
        if (moduleList == null) {
            return contexts;
        }
        List<List<ModuleInstance>> spellModules = SpellUtils.deserializeModuleList(moduleList);
        List<ItemStack> spellItems = SpellUtils.getSpellItems(spellModules);
        spellModules = SpellUtils.getEssentialModules(spellModules);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int widthOfSpace = fr.func_78256_a(" ");
        StringBuilder builder = new StringBuilder(LibrarianLib.PROXY.translate("wizardry.book.spell_recipe_structure", new Object[0]) + "\n");
        for (List<ModuleInstance> spellModuleList : spellModules) {
            String margin = null;
            for (ModuleInstance module : spellModuleList) {
                if (margin == null) {
                    margin = " - ";
                    builder.append(margin).append(module.getReadableName()).append("\n");
                    continue;
                }
                int realLength = fr.func_78256_a(margin);
                int nbOfSpace = MathHelper.func_76125_a((int)(realLength / widthOfSpace), (int)0, (int)17);
                margin = StringUtils.repeat((String)" ", (int)nbOfSpace) + "|_ ";
                builder.append(margin).append(module.getReadableName()).append("\n");
                if (nbOfSpace < 16) continue;
                builder.append("   ________________|").append("\n");
                margin = "   ";
            }
        }
        String[] lines = builder.toString().split("\n");
        StringBuilder pageChunk = new StringBuilder();
        int count = 0;
        for (String line : lines) {
            pageChunk.append(line).append("\n");
            if (++count < 16) continue;
            count = 0;
            ComponentSpellRecipe.pageFromString(book, contexts, pageChunk);
            pageChunk = new StringBuilder();
        }
        if (count != 0) {
            ComponentSpellRecipe.pageFromString(book, contexts, pageChunk);
        }
        Consumer<ComponentVoid> applier = component -> {};
        for (int i = 0; i < spellItems.size(); ++i) {
            ItemStack stack = spellItems.get(i);
            int index = i;
            applier = applier.andThen(component -> {
                ComponentStack componentStack = new ComponentStack(index % 4 * 32, index / 4 * 16);
                componentStack.getStack().setValue((Object)stack);
                component.add(new GuiComponent[]{componentStack});
                if (index != spellItems.size() - 1 && index % 4 < 3) {
                    ComponentSprite nextItem = new ComponentSprite((ISprite)book.getHomeSprite(), 32 + index % 4 * 32, index / 4 * 16 + 13, 16, 8);
                    nextItem.getColor().setValue((Object)book.getBook().getHighlightColor());
                    nextItem.getTransform().setRotate(Math.toRadians(180.0));
                    component.add(new GuiComponent[]{nextItem});
                }
            });
            if (index / 4 < 9) continue;
            Consumer<ComponentVoid> spellApplier = applier;
            contexts.add(new PaginationContext(() -> {
                ComponentVoid component = new ComponentVoid(16, 16, book.getMainBookComponent().getSize().getXi() - 32, book.getMainBookComponent().getSize().getYi() - 32);
                spellApplier.accept(component);
                return component;
            }));
            applier = component -> {};
        }
        Consumer<ComponentVoid> spellApplier = applier;
        contexts.add(new PaginationContext(() -> {
            ComponentVoid component = new ComponentVoid(16, 16, book.getMainBookComponent().getSize().getXi() - 32, book.getMainBookComponent().getSize().getYi() - 32);
            spellApplier.accept(component);
            return component;
        }));
        return contexts;
    }

    private static void pageFromString(GuiBook book, List<PaginationContext> contexts, StringBuilder page) {
        contexts.add(new PaginationContext(() -> {
            ComponentText spellStructureText = new ComponentText(16, 16, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
            spellStructureText.getUnicode().setValue((Object)true);
            spellStructureText.getEnableUnicodeBidi().setValue((Object)false);
            spellStructureText.getText().setValue((Object)page.toString());
            spellStructureText.getWrap().setValue((Object)(book.getMainBookComponent().getSize().getXi() - 32));
            return spellStructureText;
        }));
    }
}

