/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block;

import com.teamwizardry.librarianlib.features.base.block.tile.BlockModContainer;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.block.ICraftingPlateRecipe;
import com.teamwizardry.wizardry.api.block.IStructure;
import com.teamwizardry.wizardry.api.spell.SpellBuilder;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.structure.WizardryStructure;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.common.network.PacketRemoveItemCraftingPlate;
import com.teamwizardry.wizardry.common.network.PacketUpdateCraftingPlateSlot;
import com.teamwizardry.wizardry.common.tile.TileCraftingPlate;
import com.teamwizardry.wizardry.crafting.CraftingPlateRecipeManager;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import com.teamwizardry.wizardry.init.ModStructures;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockCraftingPlate
extends BlockModContainer
implements IStructure {
    private static final AxisAlignedBB AABB_CRAFTING_PLATE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);

    public BlockCraftingPlate() {
        super("crafting_plate", Material.field_151575_d, new String[0]);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.getItemForm().func_77625_d(1);
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        return 15;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileCraftingPlate();
    }

    private TileCraftingPlate getTE(IBlockAccess world, BlockPos pos) {
        return (TileCraftingPlate)world.func_175625_s(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (this.testStructure(worldIn, pos).isEmpty()) {
            TileCraftingPlate plate = this.getTE((IBlockAccess)worldIn, pos);
            if (!heldItem.func_190926_b()) {
                if (heldItem.func_77973_b() == ModItems.BOOK && playerIn.func_184812_l_()) {
                    ItemStack pearl = new ItemStack((Item)ModItems.PEARL_NACRE);
                    NBTTagList moduleList = NBTHelper.getList((ItemStack)heldItem, (String)"spellData", (int)8);
                    if (moduleList == null) {
                        return false;
                    }
                    SpellBuilder builder = new SpellBuilder(SpellUtils.getSpellItems(SpellUtils.deserializeModuleList(moduleList)));
                    NBTTagList list = new NBTTagList();
                    for (SpellRing spellRing : builder.getSpell()) {
                        list.func_74742_a((NBTBase)spellRing.serializeNBT());
                    }
                    NBTHelper.setList((ItemStack)pearl, (String)"spellData", (NBTTagList)list);
                    NBTHelper.setBoolean((ItemStack)pearl, (String)"infused", (boolean)true);
                    NBTHelper.setFloat((ItemStack)pearl, (String)"rand", (float)playerIn.field_70170_p.field_73012_v.nextFloat());
                    ((ItemStackHandler)plate.output.getHandler()).setStackInSlot(0, pearl);
                    plate.func_70296_d();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), Color.CYAN, Color.BLUE, 2.0, 2.0, 500, 300, 20, false), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                    worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.BASS_BOOM, SoundCategory.BLOCKS, 1.0f, (float)RandUtil.nextDouble(1.0, 1.5));
                    return true;
                }
                ItemStack stack = heldItem.func_77946_l();
                int oldCount = stack.func_190916_E();
                int subtractHand = playerIn.func_70093_af() ? 64 : 1;
                heldItem.func_190918_g(subtractHand);
                stack.func_190920_e(oldCount - heldItem.func_190916_E());
                boolean recipeExists = CraftingPlateRecipeManager.doesRecipeExistForItem(stack);
                if (!plate.isInventoryEmpty() && recipeExists) {
                    ((ItemStackHandler)plate.input.getHandler()).insertItem(0, stack, false);
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketUpdateCraftingPlateSlot(pos, stack), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                } else if (!recipeExists) {
                    ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)plate.realInventory.getHandler()), (ItemStack)stack, (boolean)false);
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketUpdateCraftingPlateSlot(pos, stack), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                }
                return true;
            }
            if (plate.hasInput()) {
                ItemStack extract;
                ItemStack stack = ((ItemStackHandler)plate.input.getHandler()).getStackInSlot(0);
                ICraftingPlateRecipe recipe = CraftingPlateRecipeManager.getRecipeForItem(stack);
                if (recipe != null) {
                    recipe.canceled(worldIn, pos, stack);
                }
                if (!(extract = ((ItemStackHandler)plate.input.getHandler()).extractItem(0, 1, false)).func_190926_b()) {
                    playerIn.func_191521_c(extract);
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRemoveItemCraftingPlate(pos, 0), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                    return true;
                }
            } else if (plate.hasOutput()) {
                ItemStack extract = ((ItemStackHandler)plate.output.getHandler()).extractItem(0, 1, false);
                if (!extract.func_190926_b()) {
                    playerIn.func_191521_c(extract);
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRemoveItemCraftingPlate(pos, 0), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                    return true;
                }
            } else {
                for (int i = ((ItemStackHandler)plate.realInventory.getHandler()).getSlots() - 1; i >= 0; --i) {
                    ItemStack extracted = ((ItemStackHandler)plate.realInventory.getHandler()).extractItem(i, playerIn.func_70093_af() ? 64 : 1, false);
                    if (extracted.func_190926_b()) continue;
                    playerIn.func_191521_c(extracted);
                    plate.func_70296_d();
                    playerIn.field_71070_bA.func_75142_b();
                    PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRemoveItemCraftingPlate(pos, i), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
                    break;
                }
            }
            return true;
        }
        if (playerIn.func_184812_l_() && playerIn.func_70093_af()) {
            this.buildStructure(worldIn, pos);
        } else {
            TileCraftingPlate plate = this.getTE((IBlockAccess)worldIn, pos);
            plate.revealStructure = !plate.revealStructure;
            plate.func_70296_d();
        }
        return heldItem.func_190926_b();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_CRAFTING_PLATE;
    }

    @Override
    public WizardryStructure getStructure() {
        return ModStructures.structureManager.getStructure(ModStructures.CRAFTING_PLATE);
    }
}

