/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block.fluid;

import com.teamwizardry.librarianlib.features.base.fluid.BlockModFluid;
import com.teamwizardry.librarianlib.features.base.fluid.ModFluid;
import com.teamwizardry.librarianlib.features.forgeevents.EntityUpdateEvent;
import com.teamwizardry.wizardry.api.block.FluidTracker;
import com.teamwizardry.wizardry.common.block.fluid.MaterialLethe;
import com.teamwizardry.wizardry.crafting.mana.FluidRecipeBuilder;
import com.teamwizardry.wizardry.crafting.mana.ManaRecipes;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockFluidLethe
extends BlockModFluid {
    public BlockFluidLethe(ModFluid lethe) {
        super((Fluid)lethe, (Material)new MaterialLethe(MapColor.field_151662_n));
        this.setQuantaPerBlock(6);
    }

    @SubscribeEvent
    public static void onEntityUpdate(EntityUpdateEvent event) {
        Entity entityIn = event.getEntity();
        BlockPos pos = entityIn.func_180425_c();
        World world = entityIn.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        BlockFluidLethe.run(world, pos, state.func_177230_c(), entityIn, entity -> entity instanceof EntityItem && ManaRecipes.RECIPES.keySet().stream().anyMatch(item -> item.apply(((EntityItem)entity).func_92059_d())), entity -> {
            List<Map.Entry> allEntries = ManaRecipes.RECIPES.entries().stream().filter(entry -> ((FluidRecipeBuilder.FluidCrafter)entry.getValue()).getFluid().getBlock() == state.func_177230_c() && ((Ingredient)entry.getKey()).apply(((EntityItem)entity).func_92059_d())).collect(Collectors.toList());
            allEntries.forEach(crafter -> FluidTracker.INSTANCE.addManaCraft(entity.field_70170_p, entity.func_180425_c(), ((FluidRecipeBuilder.FluidCrafter)crafter.getValue()).build()));
        });
    }

    public static void run(World world, BlockPos pos, Block block, Entity entity, Predicate<Entity> test, Consumer<Entity> process) {
        if (!(block instanceof IFluidBlock)) {
            return;
        }
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        float height = up.func_185904_a().func_76224_d() || up.func_177230_c() instanceof IFluidBlock ? 1.0f : ((IFluidBlock)block).getFilledPercentage(world, pos) * 0.875f;
        AxisAlignedBB bb = new AxisAlignedBB(pos).func_191195_a(0.0, (double)(1.0f - height), 0.0);
        AxisAlignedBB entityBox = entity.func_70046_E();
        if ((entityBox == null || entityBox.func_72326_a(bb)) && test.test(entity)) {
            process.accept(entity);
        }
    }

    private static int expToNextLevel(int currentLevel) {
        if (currentLevel > 30) {
            return 9 * currentLevel - 158;
        }
        if (currentLevel > 15) {
            return 5 * currentLevel - 38;
        }
        return 2 * currentLevel + 7;
    }
}

