/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.fairytasks;

import com.google.common.base.Predicate;
import com.teamwizardry.wizardry.api.StateGraph;
import com.teamwizardry.wizardry.api.entity.fairy.fairytasks.FairyTask;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class FairyTaskBreakBlock
extends FairyTask {
    private final StateGraph<EntityFairy> graph = new StateGraph.Builder<EntityFairy>().runWhile(fairy -> true, entityFairyBuilder -> entityFairyBuilder.run(fairy -> {
        if (fairy.isMoving()) {
            return false;
        }
        return !FairyTaskBreakBlock.breakBlock(fairy);
    }).wait(10)).build();

    private static boolean breakBlock(EntityFairy fairy) {
        Vec3d lookTarget = fairy.getLookTarget();
        if (lookTarget == null) {
            return false;
        }
        RayTraceResult trace = new RayTrace(fairy.field_70170_p, lookTarget, fairy.func_174791_d(), 3.0).setReturnLastUncollidableBlock(false).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != null && !input.equals((Object)fairy))).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        if (trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityPlayerMP player = BlockUtils.makeBreaker(fairy.field_70170_p, fairy.func_180425_c(), null);
            return BlockUtils.breakBlock(fairy.field_70170_p, trace.func_178782_a(), fairy.field_70170_p.func_180495_p(trace.func_178782_a()), player);
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void onStart(EntityFairy fairy) {
    }

    @Override
    public void onTick(EntityFairy fairy) {
        this.graph.offer(fairy);
    }

    @Override
    public void onForceTrigger(EntityFairy fairy) {
        FairyTaskBreakBlock.breakBlock(fairy);
    }

    @Override
    public void onEnd(EntityFairy fairy) {
    }

    @Override
    public void onConfigure(EntityFairy fairy, @Nullable BlockPos targetBlock, @Nullable Entity targetEntity, Vec3d lookVec) {
    }
}

