/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.fairytasks;

import com.teamwizardry.wizardry.api.StateGraph;
import com.teamwizardry.wizardry.api.entity.fairy.fairytasks.FairyTask;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class FairyTaskGrabItems
extends FairyTask {
    private final StateGraph<EntityFairy> graph = new StateGraph.Builder<EntityFairy>().runWhile(fairy -> true, entityFairyBuilder -> entityFairyBuilder.run(fairy -> {
        if (fairy.isMoving()) {
            return false;
        }
        EntityItem farthestItem = FairyTaskGrabItems.getFarthestStack(fairy);
        if (farthestItem == null || farthestItem.func_70068_e((Entity)fairy) < 1.0) {
            return false;
        }
        if (FairyTaskGrabItems.isPriorityTaken(fairy)) {
            fairy.setDataHeldItem(farthestItem.func_92059_d());
            fairy.field_70170_p.func_72900_e((Entity)farthestItem);
        } else {
            fairy.moveTo(farthestItem.func_180425_c());
        }
        return true;
    }).run(fairy -> {
        if (fairy.isMoving()) {
            return false;
        }
        if (fairy.originPos == null) {
            return false;
        }
        if (FairyTaskGrabItems.isPriorityTaken(fairy)) {
            return true;
        }
        EntityItem closestItem = FairyTaskGrabItems.getClosestStack(fairy);
        if (closestItem == null) {
            return false;
        }
        fairy.setDataHeldItem(closestItem.func_92059_d());
        fairy.field_70170_p.func_72900_e((Entity)closestItem);
        fairy.moveTo(fairy.originPos);
        return true;
    }).run(fairy -> {
        if (fairy.isMoving()) {
            return false;
        }
        if (FairyTaskGrabItems.isPriorityTaken(fairy)) {
            return true;
        }
        FairyTaskGrabItems.popItemFromHand(fairy);
        return true;
    }).wait(5)).build();

    private static List<EntityItem> getEntityItems(EntityFairy fairy) {
        return fairy.field_70170_p.func_175647_a(EntityItem.class, new AxisAlignedBB(fairy.func_180425_c()).func_186662_g(3.0), input -> input != null && !input.func_174874_s());
    }

    @Nullable
    private static EntityItem getClosestStack(EntityFairy fairy) {
        List<EntityItem> list = FairyTaskGrabItems.getEntityItems(fairy);
        list.sort((o1, o2) -> o1.func_70068_e((Entity)fairy) < o2.func_70068_e((Entity)fairy) ? -1 : 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    private static EntityItem getFarthestStack(EntityFairy fairy) {
        List<EntityItem> list = FairyTaskGrabItems.getEntityItems(fairy);
        list.sort((o1, o2) -> o1.func_70068_e((Entity)fairy) < o2.func_70068_e((Entity)fairy) ? 1 : -1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static void popItemFromHand(EntityFairy fairy) {
        ItemStack heldItem = fairy.getDataHeldItem();
        if (heldItem.func_190926_b()) {
            return;
        }
        EntityItem entityItem = new EntityItem(fairy.field_70170_p, fairy.field_70165_t, fairy.field_70163_u, fairy.field_70161_v, heldItem.func_77946_l());
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        entityItem.func_174867_a(50);
        if (fairy.field_70170_p.func_72838_d((Entity)entityItem)) {
            fairy.setDataHeldItem(ItemStack.field_190927_a);
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void onStart(EntityFairy fairy) {
    }

    @Override
    public void onTick(EntityFairy fairy) {
        this.graph.offer(fairy);
    }

    @Override
    public void onForceTrigger(EntityFairy fairy) {
        FairyTaskGrabItems.popItemFromHand(fairy);
    }

    @Override
    public void onEnd(EntityFairy fairy) {
    }

    @Override
    public void onConfigure(EntityFairy fairy, @Nullable BlockPos targetBlock, @Nullable Entity targetEntity, Vec3d lookVec) {
    }
}

