/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.entity.fairy.FairyData;
import com.teamwizardry.wizardry.api.entity.fairy.fairytasks.FairyTaskController;
import com.teamwizardry.wizardry.api.entity.fairy.fairytasks.FairyTaskRegistry;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.common.entity.EntitySpiritWight;
import com.teamwizardry.wizardry.common.entity.EntityUnicorn;
import com.teamwizardry.wizardry.common.entity.ai.FairyMoveHelper;
import com.teamwizardry.wizardry.common.entity.ai.WizardryFlyablePathNavigator;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class EntityFairy
extends EntityTameable
implements EntityFlying {
    private static final DataParameter<ItemStack> DATA_HELD_ITEM = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<NBTTagCompound> DATA_FAIRY = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<NBTTagCompound> DATA_LOOK_TARGET = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Optional<UUID>> DATA_CHAINED_FAIRY = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187203_m);
    private EntityAIAvoidEntity<EntityPlayer> avoidEntity;
    @Nonnull
    public final FairyTaskController fairyTaskController = new FairyTaskController();
    private boolean moving = false;
    @Nullable
    public Vec3d currentTarget = null;
    @Nullable
    public Vec3d currentOrigin = null;
    @Nullable
    private EnumFacing direction;
    private int steps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    private boolean stunned = false;
    @Nullable
    public BlockPos originPos = null;
    @Nullable
    public BlockPos targetPos = null;

    public EntityFairy(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70160_al = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new FairyMoveHelper((EntityLiving)this);
        this.setDataFairy(new FairyData());
        this.setLookTarget(null);
        this.direction = EnumFacing.UP;
    }

    public EntityFairy(World worldIn, FairyData fairyData) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70160_al = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new FairyMoveHelper((EntityLiving)this);
        this.setDataFairy(fairyData);
        this.setLookTarget(null);
        if (fairyData.isDepressed) {
            this.func_184224_h(true);
        }
        this.direction = EnumFacing.UP;
    }

    @Nullable
    public Vec3d getLookTarget() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(DATA_LOOK_TARGET);
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_z")) {
            return new Vec3d(NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_x"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_y"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_z"));
        }
        return null;
    }

    public void setLookTarget(Vec3d lookTarget) {
        NBTTagCompound compound = new NBTTagCompound();
        if (lookTarget == null) {
            return;
        }
        compound.func_74780_a("look_target_x", lookTarget.field_72450_a);
        compound.func_74780_a("look_target_y", lookTarget.field_72448_b);
        compound.func_74780_a("look_target_z", lookTarget.field_72449_c);
        this.func_184212_Q().func_187227_b(DATA_LOOK_TARGET, (Object)compound);
        this.func_184212_Q().func_187217_b(DATA_LOOK_TARGET);
    }

    public UUID getChainedFairy() {
        return (UUID)((Optional)this.func_184212_Q().func_187225_a(DATA_CHAINED_FAIRY)).orNull();
    }

    public void setChainedFairy(UUID uuid) {
        this.func_184212_Q().func_187227_b(DATA_CHAINED_FAIRY, (Object)Optional.fromNullable((Object)uuid));
        this.func_184212_Q().func_187217_b(DATA_CHAINED_FAIRY);
    }

    @Nullable
    public FairyData getDataFairy() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(DATA_FAIRY);
        return FairyData.deserialize(compound);
    }

    public void setDataFairy(FairyData fairy) {
        if (fairy == null) {
            return;
        }
        this.func_184212_Q().func_187227_b(DATA_FAIRY, (Object)fairy.serializeNBT());
        this.func_184212_Q().func_187217_b(DATA_FAIRY);
    }

    @Nonnull
    public ItemStack getDataHeldItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_HELD_ITEM);
    }

    public void setDataHeldItem(@Nonnull ItemStack stack) {
        this.func_184212_Q().func_187227_b(DATA_HELD_ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(DATA_HELD_ITEM);
    }

    @Nullable
    public EntityAgeable func_90011_a(@NotNull EntityAgeable ageable) {
        return null;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70878_b(@NotNull EntityAnimal otherAnimal) {
        return false;
    }

    public boolean func_70652_k(@NotNull Entity entityIn) {
        if (entityIn instanceof EntityUnicorn) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_FAIRY, (Object)new FairyData().serializeNBT());
        this.func_184212_Q().func_187214_a(DATA_LOOK_TARGET, (Object)new NBTTagCompound());
        this.func_184212_Q().func_187214_a(DATA_HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(DATA_CHAINED_FAIRY, (Object)Optional.absent());
    }

    protected void func_175544_ck() {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy != null && dataFairy.isDepressed) {
            return;
        }
        if (this.avoidEntity == null) {
            this.avoidEntity = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 2.0, 3.0);
        }
        this.field_70714_bg.func_85156_a(this.avoidEntity);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(0, this.avoidEntity);
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityUnicorn.class, 16.0f, 2.0, 3.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntitySpiritWight.class, 16.0f, 2.0, 3.0));
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110140_aT().func_111150_b(EntityPlayer.REACH_DISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(RandUtil.nextDouble(2.0, 3.0));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111128_a(5.0);
    }

    @NotNull
    public PathNavigate func_175447_b(@NotNull World worldIn) {
        return new WizardryFlyablePathNavigator((EntityLiving)this, worldIn);
    }

    public void func_82167_n(Entity entity) {
        if (this.func_110143_aJ() > 0.0f) {
            if (entity.func_70005_c_().equals(this.func_70005_c_())) {
                return;
            }
            ((EntityLivingBase)entity).field_70181_x += 0.1;
            ((EntityLivingBase)entity).func_70604_c((EntityLivingBase)this);
        }
        entity.field_70143_R = 0.0f;
    }

    public boolean func_70067_L() {
        return true;
    }

    @SubscribeEvent
    public static void onStun(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        block0: for (EntityFairy fairy : event.world.func_175644_a(EntityFairy.class, input -> input != null && !input.field_70128_L)) {
            fairy.stunned = false;
            for (EntityPlayer player : event.world.func_72872_a(EntityPlayer.class, fairy.func_174813_aQ().func_186662_g(5.0))) {
                for (EnumHand hand : EnumHand.values()) {
                    ItemStack stack = player.func_184586_b(hand);
                    if (stack.func_77973_b() != ModItems.FAIRY_BELL) continue;
                    fairy.stunned = true;
                    continue block0;
                }
            }
        }
    }

    public void moveTo(@Nonnull BlockPos pos) {
        Vec3d to = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        this.moveTo(to);
    }

    public void moveTo(@Nonnull Vec3d to) {
        this.currentTarget = to;
        this.currentOrigin = this.func_174791_d();
        this.moving = true;
        for (EnumFacing facing : EnumFacing.values()) {
            if (!this.field_70170_p.func_175623_d(this.func_180425_c().func_177972_a(facing))) continue;
            this.selectNextMoveDirection(facing.func_176740_k());
            return;
        }
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
        this.field_70143_R = 0.0f;
        FairyData dataFairy = this.getDataFairy();
        float size = dataFairy != null && dataFairy.wasTamperedWith ? 0.2f : 1.0f;
        this.func_98055_j(size);
        if (this.field_70128_L) {
            return;
        }
        if (dataFairy != null && dataFairy.isDepressed) {
            Vec3d lookTarget = this.getLookTarget();
            if (lookTarget != null && !this.moving) {
                this.func_70671_ap().func_75650_a(lookTarget.field_72450_a, lookTarget.field_72448_b, lookTarget.field_72449_c, 20.0f, 20.0f);
            }
            if (!this.field_70714_bg.field_75782_a.isEmpty()) {
                ArrayList tempTasks = new ArrayList(this.field_70714_bg.field_75782_a);
                for (EntityAITasks.EntityAITaskEntry taskEntry : tempTasks) {
                    this.field_70714_bg.func_85156_a(taskEntry.field_75733_a);
                }
            }
            if (!this.field_70715_bh.field_75782_a.isEmpty()) {
                ArrayList tempTargetTasks = new ArrayList(this.field_70715_bh.field_75782_a);
                for (EntityAITasks.EntityAITaskEntry taskEntry : tempTargetTasks) {
                    this.field_70715_bh.func_85156_a(taskEntry.field_75733_a);
                }
            }
        }
        ProjectileHelper.func_188803_a((Entity)this, (float)0.5f);
        if (!this.field_70170_p.field_72995_K && !this.isStunned()) {
            this.fairyTaskController.tick(this);
        }
        if (dataFairy != null && this.func_70661_as().func_75500_f()) {
            if (!dataFairy.isDepressed) {
                this.func_70605_aq().func_75642_a(this.field_70165_t + RandUtil.nextDouble(-32.0, 32.0), this.field_70163_u + RandUtil.nextDouble(-32.0, 32.0), this.field_70161_v + RandUtil.nextDouble(-32.0, 32.0), 2.0);
            } else if (this.moving && !this.isStunned()) {
                if (this.currentTarget == null) {
                    return;
                }
                double v = this.func_174791_d().func_72438_d(this.currentTarget);
                if (v <= 0.5) {
                    this.func_70107_b(this.currentTarget.field_72450_a, this.currentTarget.field_72448_b, this.currentTarget.field_72449_c);
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.targetDeltaX = 0.0;
                    this.targetDeltaY = 0.0;
                    this.targetDeltaZ = 0.0;
                    this.moving = false;
                    this.currentTarget = null;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.targetDeltaX = MathHelper.func_151237_a((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                    this.targetDeltaY = MathHelper.func_151237_a((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                    this.targetDeltaZ = MathHelper.func_151237_a((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                    this.field_70159_w += (this.targetDeltaX - this.field_70159_w) * 0.2;
                    this.field_70181_x += (this.targetDeltaY - this.field_70181_x) * 0.2;
                    this.field_70179_y += (this.targetDeltaZ - this.field_70179_y) * 0.2;
                }
                this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                if (this.currentTarget != null) {
                    if (this.steps > 0) {
                        --this.steps;
                        if (this.steps == 0) {
                            this.selectNextMoveDirection(this.direction == null ? null : this.direction.func_176740_k());
                        }
                    }
                    if (this.direction != null) {
                        BlockPos blockpos = new BlockPos((Entity)this);
                        EnumFacing.Axis enumfacing$axis = this.direction.func_176740_k();
                        if (this.field_70170_p.func_175677_d(blockpos.func_177972_a(this.direction), false)) {
                            this.selectNextMoveDirection(enumfacing$axis);
                        } else {
                            BlockPos blockpos1 = new BlockPos(this.currentTarget);
                            if (enumfacing$axis == EnumFacing.Axis.X && blockpos.func_177958_n() == blockpos1.func_177958_n() || enumfacing$axis == EnumFacing.Axis.Z && blockpos.func_177952_p() == blockpos1.func_177952_p() || enumfacing$axis == EnumFacing.Axis.Y && blockpos.func_177956_o() == blockpos1.func_177956_o()) {
                                this.selectNextMoveDirection(enumfacing$axis);
                            }
                        }
                    }
                }
            }
        }
    }

    private void setDirection(@Nullable EnumFacing directionIn) {
        this.direction = directionIn;
    }

    private void selectNextMoveDirection(@Nullable EnumFacing.Axis p_184569_1_) {
        double d0 = 0.5;
        BlockPos blockpos = this.currentTarget == null ? new BlockPos((Entity)this).func_177977_b() : new BlockPos(this.currentTarget);
        double d1 = (double)blockpos.func_177958_n() + 0.5;
        double d2 = (double)blockpos.func_177956_o() + d0;
        double d3 = (double)blockpos.func_177952_p() + 0.5;
        EnumFacing enumfacing = null;
        RayTraceResult result = new RayTrace(this.field_70170_p, this.func_174791_d().func_178786_a(this.field_70142_S, this.field_70137_T, this.field_70136_U).func_72432_b(), this.func_174791_d(), 1.0).setSkipEntities(true).setIgnoreBlocksWithoutBoundingBoxes(true).setReturnLastUncollidableBlock(false).trace();
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && !this.field_70170_p.func_175623_d(result.func_178782_a()) && blockpos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 4.0) {
            BlockPos blockpos1 = new BlockPos((Entity)this);
            ArrayList list = Lists.newArrayList();
            if (p_184569_1_ != EnumFacing.Axis.X) {
                if (blockpos1.func_177958_n() < blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177974_f())) {
                    list.add(EnumFacing.EAST);
                } else if (blockpos1.func_177958_n() > blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177976_e())) {
                    list.add(EnumFacing.WEST);
                }
            }
            if (p_184569_1_ != EnumFacing.Axis.Y) {
                if (blockpos1.func_177956_o() < blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177984_a())) {
                    list.add(EnumFacing.UP);
                } else if (blockpos1.func_177956_o() > blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177977_b())) {
                    list.add(EnumFacing.DOWN);
                }
            }
            if (p_184569_1_ != EnumFacing.Axis.Z) {
                if (blockpos1.func_177952_p() < blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177968_d())) {
                    list.add(EnumFacing.SOUTH);
                } else if (blockpos1.func_177952_p() > blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177978_c())) {
                    list.add(EnumFacing.NORTH);
                }
            }
            enumfacing = EnumFacing.func_176741_a((Random)this.field_70146_Z);
            if (list.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_175623_d(blockpos1.func_177972_a(enumfacing)) && i > 0; --i) {
                    enumfacing = EnumFacing.func_176741_a((Random)this.field_70146_Z);
                }
            } else {
                enumfacing = (EnumFacing)list.get(this.field_70146_Z.nextInt(list.size()));
            }
            d1 = this.field_70165_t + (double)enumfacing.func_82601_c();
            d2 = this.field_70163_u + (double)enumfacing.func_96559_d();
            d3 = this.field_70161_v + (double)enumfacing.func_82599_e();
        }
        this.setDirection(enumfacing);
        double d6 = d1 - this.field_70165_t;
        double d7 = d2 - this.field_70163_u;
        double d4 = d3 - this.field_70161_v;
        double d5 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7 + d4 * d4));
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.field_70160_al = true;
        this.steps = 10;
    }

    @NotNull
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() == ModItems.JAR_ITEM && heldItem.func_77952_i() == 0) {
            this.succFairy(heldItem, player);
            return EnumActionResult.SUCCESS;
        }
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() != ModItems.FAIRY_BELL) {
            ResourceLocation task = FairyTaskRegistry.getAcceptableTask(heldItem, this);
            if (task != FairyTaskRegistry.IDLE_TASK) {
                this.fairyTaskController.setTask(this, task);
                this.func_184185_a((SoundEvent)ModSounds.POSITIVE_LIGHT_TWINKLE, 1.0f, RandUtil.nextFloat());
                heldItem.func_190918_g(1);
            } else {
                this.func_184185_a((SoundEvent)ModSounds.NEGATIVELY_PITCHED_BREATHE_PUHH, 1.0f, RandUtil.nextFloat());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    private void succFairy(ItemStack stack, EntityPlayer player) {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy == null) {
            return;
        }
        stack.func_190918_g(1);
        ItemStack jar = new ItemStack((Item)ModItems.JAR_ITEM);
        jar.func_77964_b(2);
        dataFairy.wasTamperedWith = true;
        NBTHelper.setTag((ItemStack)jar, (String)"fairy", (NBTBase)dataFairy.serializeNBT());
        player.func_191521_c(jar);
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        if (this.func_190530_aW()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            FairyData dataFairy = this.getDataFairy();
            if (dataFairy == null) {
                return;
            }
            if (dataFairy.isDepressed) {
                ItemStack stack = new ItemStack((Item)ModItems.FAIRY_ITEM);
                NBTHelper.setTag((ItemStack)stack, (String)"fairy", (NBTBase)dataFairy.serializeNBT());
                this.field_70170_p.func_72900_e((Entity)this);
                EntityItem entityItem = new EntityItem(this.field_70170_p);
                entityItem.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                entityItem.func_92058_a(stack);
                entityItem.func_174867_a(20);
                entityItem.func_174873_u();
                this.field_70170_p.func_72838_d((Entity)entityItem);
                return;
            }
            super.func_70645_a(cause);
            if (this.func_110143_aJ() <= 0.0f) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(this.func_174791_d().func_72441_c(0.0, 0.25, 0.0), dataFairy.primaryColor, dataFairy.secondaryColor, 0.5, 0.5, RandUtil.nextInt(100, 200), 75, 25, true), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 256.0));
            }
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.SUBTLE_MAGIC_BOOK_GLINT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.SUBTLE_MAGIC_BOOK_GLINT;
    }

    public void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy == null) {
            return;
        }
        ItemStack fairyWings = new ItemStack((Item)ModItems.FAIRY_WINGS);
        ItemStack fairyDust = new ItemStack((Item)ModItems.FAIRY_DUST);
        this.func_70099_a(fairyDust, RandUtil.nextFloat());
        this.func_70099_a(fairyWings, RandUtil.nextFloat());
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public void func_70037_a(NBTTagCompound compound) {
        String resource;
        NBTTagCompound heldItem;
        super.func_70037_a(compound);
        this.setDataFairy(FairyData.deserialize(NBTHelper.getCompoundTag((NBTTagCompound)compound, (String)"fairy")));
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"held_item") && (heldItem = NBTHelper.getCompoundTag((NBTTagCompound)compound, (String)"held_item")) != null) {
            this.setDataHeldItem(new ItemStack(heldItem));
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"chained_fairy")) {
            this.setChainedFairy(NBTHelper.getUniqueId((NBTTagCompound)compound, (String)"chained_fairy"));
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_z")) {
            this.setLookTarget(new Vec3d(NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_x"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_y"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_z")));
        } else {
            this.setLookTarget(null);
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"current_target_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"current_target_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"current_target_z")) {
            this.currentTarget = new Vec3d(NBTHelper.getDouble((NBTTagCompound)compound, (String)"current_target_x"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"current_target_y"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"current_target_z"));
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"origin_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"origin_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"origin_z")) {
            this.originPos = new BlockPos(NBTHelper.getInteger((NBTTagCompound)compound, (String)"origin_x"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"origin_y"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"origin_z"));
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"target_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"target_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"target_z")) {
            this.targetPos = new BlockPos(NBTHelper.getInteger((NBTTagCompound)compound, (String)"target_x"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"target_y"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"target_z"));
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"moving")) {
            this.moving = NBTHelper.getBoolean((NBTTagCompound)compound, (String)"moving", (boolean)true);
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"stunned")) {
            this.stunned = NBTHelper.getBoolean((NBTTagCompound)compound, (String)"stunned", (boolean)true);
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"fairy_task") && (resource = NBTHelper.getString((NBTTagCompound)compound, (String)"fairy_task")) != null) {
            this.fairyTaskController.setTask(this, new ResourceLocation(resource));
        }
        if (this.direction != null) {
            compound.func_74768_a("direction", this.direction.func_176745_a());
        }
        if (compound.func_150297_b("direction", 99)) {
            this.direction = EnumFacing.func_82600_a((int)compound.func_74762_e("direction"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        BlockPos target;
        BlockPos origin;
        Vec3d targetLook;
        super.func_70014_b(compound);
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy != null) {
            NBTHelper.setCompoundTag((NBTTagCompound)compound, (String)"fairy", (NBTTagCompound)dataFairy.serializeNBT());
        }
        NBTTagCompound stackCompound = new NBTTagCompound();
        this.getDataHeldItem().func_77955_b(stackCompound);
        NBTHelper.setCompoundTag((NBTTagCompound)compound, (String)"held_item", (NBTTagCompound)stackCompound);
        UUID uuid = this.getChainedFairy();
        if (uuid != null) {
            NBTHelper.setUniqueId((NBTTagCompound)compound, (String)"chained_fairy", (UUID)uuid);
        }
        if ((targetLook = this.getLookTarget()) != null) {
            compound.func_74780_a("look_target_x", targetLook.field_72450_a);
            compound.func_74780_a("look_target_y", targetLook.field_72448_b);
            compound.func_74780_a("look_target_z", targetLook.field_72449_c);
        }
        if (this.currentTarget != null) {
            compound.func_74780_a("current_target_x", this.currentTarget.field_72450_a);
            compound.func_74780_a("current_target_y", this.currentTarget.field_72448_b);
            compound.func_74780_a("current_target_z", this.currentTarget.field_72449_c);
        }
        if ((origin = this.originPos) != null) {
            compound.func_74768_a("origin_x", origin.func_177958_n());
            compound.func_74768_a("origin_y", origin.func_177956_o());
            compound.func_74768_a("origin_z", origin.func_177952_p());
        }
        if ((target = this.targetPos) != null) {
            compound.func_74768_a("target_x", target.func_177958_n());
            compound.func_74768_a("target_y", target.func_177956_o());
            compound.func_74768_a("target_z", target.func_177952_p());
        }
        compound.func_74757_a("moving", this.moving);
        compound.func_74757_a("stunned", this.stunned);
        NBTHelper.setString((NBTTagCompound)compound, (String)"fairy_task", (String)this.fairyTaskController.getLocation().toString());
    }
}

