/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity;

import com.teamwizardry.librarianlib.features.base.entity.EntityMod;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItem;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItemRegistry;
import com.teamwizardry.wizardry.common.tile.TileHaloInfuser;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityHaloInfusionItem
extends EntityMod {
    private BlockPos infuserPos;
    private int slot;
    @Nonnull
    private HaloInfusionItem haloInfusionItem = HaloInfusionItemRegistry.EMPTY;

    public EntityHaloInfusionItem(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70160_al = true;
    }

    public EntityHaloInfusionItem(World worldIn, @Nonnull HaloInfusionItem item, BlockPos infuserPos, int slot) {
        super(worldIn);
        this.infuserPos = infuserPos;
        this.slot = slot;
        this.func_70105_a(1.0f, 1.0f);
        this.haloInfusionItem = item;
        this.field_70160_al = true;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p == null || this.infuserPos == null) {
            return;
        }
        TileEntity tile = this.field_70170_p.func_175625_s(this.infuserPos);
        if (!(tile instanceof TileHaloInfuser)) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    public boolean func_70067_L() {
        if (this.field_70170_p == null || this.infuserPos == null) {
            return false;
        }
        TileEntity tile = this.field_70170_p.func_175625_s(this.infuserPos);
        return tile instanceof TileHaloInfuser && !((TileHaloInfuser)tile).getHalo().func_190926_b();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        TileEntity tile = this.field_70170_p.func_175625_s(this.infuserPos);
        if (!(tile instanceof TileHaloInfuser)) {
            this.field_70170_p.func_72900_e((Entity)this);
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            ItemStack slotted = this.getHaloInfusionItem().getStack();
            if (!slotted.func_190926_b()) {
                player.func_184611_a(hand, slotted);
                this.setHaloInfusionItem(HaloInfusionItemRegistry.EMPTY, false);
                return true;
            }
            return true;
        }
        for (HaloInfusionItem haloInfusionItem : HaloInfusionItemRegistry.getItems()) {
            if (!haloInfusionItem.getStack().func_77969_a(heldItem)) continue;
            this.setHaloInfusionItem(haloInfusionItem, false);
            return true;
        }
        return true;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.haloInfusionItem = HaloInfusionItem.deserialize(compound.func_74779_i("halo_infusion_item"));
        this.infuserPos = BlockPos.func_177969_a((long)compound.func_74763_f("infuser_pos"));
        this.slot = compound.func_74762_e("slot");
        this.setHaloInfusionItem(this.haloInfusionItem, true);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74778_a("halo_infusion_item", this.haloInfusionItem.getNbtName());
        compound.func_74772_a("infuser_pos", this.infuserPos.func_177986_g());
        compound.func_74768_a("slot", this.slot);
    }

    public BlockPos getInfuserPos() {
        return this.infuserPos;
    }

    @Nonnull
    public HaloInfusionItem getHaloInfusionItem() {
        return this.haloInfusionItem;
    }

    public void setHaloInfusionItem(@Nonnull HaloInfusionItem haloInfusionItem, boolean soft) {
        this.haloInfusionItem = haloInfusionItem;
        if (soft) {
            return;
        }
        TileEntity tile = this.field_70170_p.func_175625_s(this.infuserPos);
        if (tile instanceof TileHaloInfuser) {
            TileHaloInfuser haloInfuser = (TileHaloInfuser)tile;
            ItemStack halo = haloInfuser.getHalo();
            NBTTagList slots = NBTHelper.getList((ItemStack)halo, (String)"slots", NBTTagString.class);
            if (slots == null || slots.func_74745_c() < HaloInfusionItemRegistry.getItems().size() - 1) {
                slots = new NBTTagList();
                for (int i = 0; i < HaloInfusionItemRegistry.getItems().size(); ++i) {
                    slots.func_74742_a((NBTBase)new NBTTagString(HaloInfusionItemRegistry.EMPTY.getNbtName()));
                }
            }
            slots.func_150304_a(this.slot, (NBTBase)new NBTTagString(haloInfusionItem.getNbtName()));
            NBTHelper.setList((ItemStack)halo, (String)"slots", (NBTTagList)slots);
        }
    }
}

