/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.capability.player.miscdata.IMiscCapability;
import com.teamwizardry.wizardry.api.capability.player.miscdata.MiscCapabilityProvider;
import com.teamwizardry.wizardry.api.entity.fairy.FairyData;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.common.network.capability.PacketUpdateMiscCapToServer;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="wizardry")
public class ItemFairyBell
extends ItemMod {
    public ItemFairyBell() {
        super("fairy_bell", new String[0]);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onScroll(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (Keyboard.isCreated() && event.getDwheel() != 0) {
            for (EnumHand hand : EnumHand.values()) {
                IMiscCapability cap;
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() != ModItems.FAIRY_BELL || (cap = MiscCapabilityProvider.getCap((Entity)Minecraft.func_71410_x().field_71439_g)) == null) continue;
                cap.setSelectedFairy(null);
                PacketHandler.NETWORK.sendToServer((IMessage)new PacketUpdateMiscCapToServer((NBTTagCompound)cap.serializeNBT()));
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (playerIn.field_70170_p.field_72995_K || playerIn.func_70093_af()) {
            return super.func_111207_a(stack, playerIn, target, hand);
        }
        if (target instanceof EntityFairy) {
            IMiscCapability cap;
            EntityFairy targetFairy = (EntityFairy)target;
            FairyData targetData = targetFairy.getDataFairy();
            if (targetData == null) {
                return super.func_111207_a(stack, playerIn, target, hand);
            }
            if (targetData.isDepressed && (cap = MiscCapabilityProvider.getCap((Entity)playerIn)) != null) {
                UUID selected = cap.getSelectedFairyUUID();
                if (selected != null && selected.equals(targetFairy.func_110124_au())) {
                    cap.setSelectedFairy(null);
                    playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.25f);
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("item.wizardry:fairy_bell.status.deselected", new Object[0]), true);
                } else if (selected != null && !selected.equals(targetFairy.func_110124_au())) {
                    List list = playerIn.field_70170_p.field_72996_f;
                    for (Entity entity : list) {
                        if (!(entity instanceof EntityFairy) || !entity.func_110124_au().equals(selected) || entity.field_70128_L) continue;
                        ((EntityFairy)entity).setChainedFairy(targetFairy.func_110124_au());
                        targetFairy.setChainedFairy(selected);
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("item.wizardry:fairy_bell.status.linked_to_fairy", new Object[0]), true);
                        break;
                    }
                } else {
                    cap.setSelectedFairy(targetFairy.func_110124_au());
                    boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
                    if (!movingMode) {
                        playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.75f);
                    } else {
                        playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 1.25f);
                    }
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(movingMode ? "item.wizardry:fairy_bell.status.fairy_moving" : "item.wizardry:fairy_bell.status.fairy_aiming", new Object[0]), true);
                }
                cap.dataChanged((Entity)playerIn);
            }
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
        if (movingMode) {
            return LibrarianLib.PROXY.translate("item.wizardry:fairy_bell_moving_mode", new Object[0]);
        }
        return LibrarianLib.PROXY.translate("item.wizardry:fairy_bell_aiming_mode", new Object[0]);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @NotNull EnumHand handIn) {
        IBlockState state;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)playerIn);
        if (cap == null) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        EntityFairy entityFairy = cap.getSelectedFairyEntity(worldIn);
        double reach = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d posEyes = playerIn.func_174791_d().func_72441_c(0.0, (double)playerIn.func_70047_e(), 0.0);
        RayTraceResult rayTraceResult = new RayTrace(worldIn, playerIn.func_70676_i(1.0f), posEyes, reach).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != null && !input.func_110124_au().equals(playerIn.func_110124_au()))).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY && rayTraceResult.field_72308_g instanceof EntityFairy && entityFairy != null && rayTraceResult.field_72308_g.func_110124_au().equals(entityFairy.func_110124_au())) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (playerIn.func_70093_af()) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"moving_mode", (!NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true) ? 1 : 0) != 0);
            cap.setSelectedFairy(null);
            cap.dataChanged((Entity)playerIn);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (entityFairy == null) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (rayTraceResult.field_72307_f == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (worldIn.func_175667_e(rayTraceResult.func_178782_a()) && (state = worldIn.func_180495_p(rayTraceResult.func_178782_a())).func_177230_c().func_149703_v()) {
            boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
            if (entityFairy.originPos != null && !movingMode) {
                Vec3d hitVec = rayTraceResult.field_72307_f;
                Vec3d subtract = hitVec.func_178788_d(entityFairy.func_174791_d());
                subtract = new Vec3d(MathHelper.func_151237_a((double)subtract.field_72450_a, (double)(-ConfigValues.fairyReach), (double)ConfigValues.fairyReach), MathHelper.func_151237_a((double)subtract.field_72448_b, (double)(-ConfigValues.fairyReach), (double)ConfigValues.fairyReach), MathHelper.func_151237_a((double)subtract.field_72449_c, (double)(-ConfigValues.fairyReach), (double)ConfigValues.fairyReach));
                entityFairy.setLookTarget(subtract);
                playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.75f);
                cap.setSelectedFairy(null);
                cap.dataChanged((Entity)playerIn);
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        if (worldIn.field_72995_K || playerIn.func_70093_af()) {
            return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)playerIn);
        if (cap == null) {
            return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        EntityFairy entityFairy = cap.getSelectedFairyEntity(worldIn);
        if (entityFairy == null) {
            return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        cap.setSelectedFairy(null);
        cap.dataChanged((Entity)playerIn);
        if (worldIn.func_175667_e(pos) && !worldIn.func_175623_d(pos) && (state = worldIn.func_180495_p(pos)).func_177230_c().func_149703_v()) {
            ItemStack stack = playerIn.func_184586_b(hand);
            boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
            if (entityFairy.originPos != null) {
                if (!movingMode) {
                    Vec3d hitVec = new Vec3d((Vec3i)pos).func_72441_c((double)hitX, (double)hitY, (double)hitZ);
                    Vec3d subtract = hitVec.func_178788_d(entityFairy.func_174791_d());
                    subtract = new Vec3d(MathHelper.func_151237_a((double)subtract.field_72450_a, (double)(-ConfigValues.fairyReach), (double)ConfigValues.fairyReach), MathHelper.func_151237_a((double)subtract.field_72448_b, (double)(-ConfigValues.fairyReach), (double)ConfigValues.fairyReach), MathHelper.func_151237_a((double)subtract.field_72449_c, (double)(-ConfigValues.fairyReach), (double)ConfigValues.fairyReach));
                    entityFairy.setLookTarget(subtract);
                    playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.75f);
                    cap.setSelectedFairy(null);
                    cap.dataChanged((Entity)playerIn);
                } else {
                    entityFairy.targetPos = pos.func_177972_a(facing);
                    entityFairy.setLookTarget(null);
                    playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 1.25f);
                }
            }
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }
}

