/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.entity.EntityBackupZombie;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_backup")
@Mod.EventBusSubscriber
public class ModuleEffectBackup
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_time"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        if (world.field_72995_K) {
            return true;
        }
        Vec3d targetPos = spell.getTarget(world);
        EnumFacing facing = spell.getData(SpellData.DefaultKeys.FACE_HIT);
        Entity caster = spell.getCaster(world);
        double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 20.0f;
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        if (targetPos == null) {
            return true;
        }
        if (!(caster instanceof EntityLivingBase)) {
            return true;
        }
        if (facing != null && !world.func_175623_d(new BlockPos(targetPos))) {
            targetPos = new Vec3d((Vec3i)new BlockPos(targetPos).func_177972_a(facing)).func_72441_c(0.5, 0.5, 0.5);
        }
        UUID player = caster.func_110124_au();
        WizardryWorld world1 = WizardryWorldCapability.get(world);
        if (world1 == null) {
            return true;
        }
        if (world1.getBackupCount(player) < ConfigValues.maxZombies) {
            EntityBackupZombie zombie = new EntityBackupZombie(world, (EntityLivingBase)caster, (int)duration);
            zombie.func_70107_b(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c);
            zombie.field_98038_p = true;
            world.func_72838_d((Entity)zombie);
            world1.incBackupCount(player);
        }
        return true;
    }

    @SubscribeEvent
    public static void onZombieDeath(LivingDeathEvent e) {
        WizardryWorld world;
        if (e.getEntity() instanceof EntityBackupZombie && ((EntityBackupZombie)e.getEntity()).getOwner() != null && (world = WizardryWorldCapability.get(e.getEntity().field_70170_p)) != null) {
            world.decBackupCount(((EntityBackupZombie)e.getEntity()).getOwner());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        glitter.enableMotionCalculation();
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setAcceleration(new Vec3d(0.0, -0.05, 0.0));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)RandUtil.nextInt(20, 30), (int)0, (aFloat, particleBuilder) -> {
            if (RandUtil.nextInt(5) == 0) {
                glitter.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            } else {
                glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            }
            glitter.setScale(RandUtil.nextFloat());
            glitter.setLifetime(RandUtil.nextInt(50, 100));
            glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(0.01, 0.05), RandUtil.nextDouble(-0.05, 0.05)));
        });
    }
}

