/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_gravity_well")
public class ModuleEffectGravityWell
implements IModuleEffect,
ILingeringModule {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_increase_potency", "modifier_extend_time"};
    }

    @Override
    public boolean runOnStart(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        return spellRing.taxCaster(world, spell, true);
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return false;
        }
        double area = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        for (Entity entity : world.func_72839_b(null, new AxisAlignedBB(new BlockPos(position)).func_72314_b(area, area, area))) {
            double dist;
            if (entity == null || (dist = entity.func_174791_d().func_72438_d(position)) < 2.0 || dist > area) continue;
            double upperMag = (double)spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell) / 50.0;
            double scale = 1.5;
            double mag = upperMag * (1.5 * dist / (-1.5 * dist - 1.0) + 1.0);
            Vec3d dir = position.func_178788_d(entity.func_174791_d()).func_72432_b().func_186678_a(mag);
            entity.field_70159_w += dir.field_72450_a;
            entity.field_70181_x += dir.field_72448_b;
            entity.field_70179_y += dir.field_72449_c;
            entity.field_70143_R = 0.0f;
            entity.field_70133_I = true;
            spell.addData(SpellData.DefaultKeys.ENTITY_HIT, entity.func_145782_y());
            if (!(entity instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
        double maxPotency = spellRing.getModule() != null ? (double)spellRing.getModule().getAttributeRanges().get((Object)AttributeRegistry.POTENCY).max : 1.0;
        ParticleBuilder glitter = new ParticleBuilder(0);
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)10, (int)10, (aFloat, particleBuilder) -> {
            particleBuilder.setScale((float)RandUtil.nextDouble(0.3, 1.0));
            particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, (float)RandUtil.nextDouble(0.6, 1.0)));
            particleBuilder.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            particleBuilder.setLifetime(RandUtil.nextInt(20, 30));
            particleBuilder.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            particleBuilder.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z).func_72432_b().func_186678_a((double)RandUtil.nextFloat((float)((maxPotency - potency) / maxPotency / 10.0))));
            particleBuilder.addMotion(particleBuilder.getPositionOffset().func_186678_a(-1.0 / RandUtil.nextDouble(10.0, 30.0)));
        });
    }

    @Override
    public int getLingeringTime(World world, SpellData spell, SpellRing spellRing) {
        return (int)(spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f);
    }
}

