/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.vanish;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.events.EntityRenderShadowAndFireEvent;
import com.teamwizardry.wizardry.common.network.PacketSyncVanish;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class VanishTracker {
    private static final List<VanishedObject> vanishes = new ArrayList<VanishedObject>();
    private static final Deque<VanishedObject> adds = new ArrayDeque<VanishedObject>();

    public static void addVanishObject(int entityID, int time) {
        for (VanishedObject v : vanishes) {
            if (v == null || v.entityID != entityID) continue;
            v.tick = time;
            return;
        }
        for (VanishedObject v : adds) {
            if (v == null || v.entityID != entityID) continue;
            v.tick = time;
            return;
        }
        adds.add(new VanishedObject(entityID, time));
    }

    public static NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList vanishList = new NBTTagList();
        for (VanishedObject v : vanishes) {
            vanishList.func_74742_a((NBTBase)v.serialize());
        }
        NBTTagList addsList = new NBTTagList();
        for (VanishedObject v : adds) {
            addsList.func_74742_a((NBTBase)v.serialize());
        }
        compound.func_74782_a("vanishes", (NBTBase)vanishList);
        compound.func_74782_a("adds", (NBTBase)addsList);
        return compound;
    }

    public static void deserialize(NBTTagCompound compound) {
        NBTTagList list;
        if (compound.func_74764_b("vanishes")) {
            vanishes.clear();
            list = compound.func_150295_c("vanishes", 10);
            for (NBTBase base : list) {
                if (!(base instanceof NBTTagCompound)) continue;
                vanishes.add(VanishedObject.deserialize((NBTTagCompound)base));
            }
        }
        if (compound.func_74764_b("adds")) {
            adds.clear();
            list = compound.func_150295_c("adds", 10);
            for (NBTBase base : list) {
                if (!(base instanceof NBTTagCompound)) continue;
                adds.add(VanishedObject.deserialize((NBTTagCompound)base));
            }
        }
    }

    public static boolean isVanished(Entity entity) {
        int id = entity.func_145782_y();
        for (VanishedObject v : vanishes) {
            if (v.entityID != id) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void vanishTicker(TickEvent.WorldTickEvent event) {
        VanishedObject entry2;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.type != TickEvent.Type.WORLD) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        int sizeAddsBefore = adds.size();
        int sizeVanishesBefore = vanishes.size();
        while ((entry2 = adds.pollFirst()) != null) {
            vanishes.add(entry2);
        }
        vanishes.removeIf(entry -> {
            if (--entry.tick < 0) {
                Entity e = event.world.func_73045_a(entry.entityID);
                if (e != null && !event.world.field_72995_K) {
                    event.world.func_184133_a(null, e.func_180425_c(), (SoundEvent)ModSounds.ETHEREAL_PASS_BY, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                }
                return true;
            }
            return false;
        });
        int sizeAddsAfter = adds.size();
        int sizeVanishesAfter = vanishes.size();
        if (!event.world.field_72995_K && sizeAddsAfter != sizeAddsBefore || sizeVanishesAfter != sizeVanishesBefore) {
            PacketHandler.NETWORK.sendToAll((IMessage)new PacketSyncVanish(VanishTracker.serialize()));
        }
    }

    @SubscribeEvent
    public static void interact(PlayerInteractEvent event) {
        if (VanishTracker.isVanished((Entity)event.getEntityPlayer())) {
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setResult(Event.Result.DENY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderItem(RenderHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (VanishTracker.isVanished((Entity)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void ai(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLivingBase potentialPotion = ((EntityLiving)event.getEntityLiving()).func_70638_az();
        if (potentialPotion != null && VanishTracker.isVanished((Entity)potentialPotion)) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void doRenderOverride(RenderLivingEvent.Pre event) {
        EntityLivingBase entity = event.getEntity();
        if (VanishTracker.isVanished((Entity)entity)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderShadowAndFire(EntityRenderShadowAndFireEvent event) {
        boolean iWalked;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean bl = iWalked = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_72438_d(new Vec3d(player.field_70169_q, player.field_70167_r, player.field_70166_s)) > 0.2;
        if (!(event.entity instanceof EntityLivingBase)) {
            return;
        }
        if (VanishTracker.isVanished(event.entity)) {
            event.override = true;
        }
    }

    public static class VanishedObject {
        final int entityID;
        int tick;

        public VanishedObject(int entityID, int tick) {
            this.entityID = entityID;
            this.tick = tick;
        }

        @Nullable
        public static VanishedObject deserialize(NBTTagCompound compound) {
            if (compound.func_74764_b("entity_id") && compound.func_74764_b("tick")) {
                return new VanishedObject(compound.func_74762_e("entity_id"), compound.func_74762_e("tick"));
            }
            return null;
        }

        public NBTTagCompound serialize() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("entity_id", this.entityID);
            compound.func_74768_a("tick", this.tick);
            return compound;
        }
    }
}

