/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.common.entity.projectile.EntitySpellProjectile;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_projectile")
public class ModuleShapeProjectile
implements IModuleShape {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_range", "modifier_increase_speed"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        if (world.field_72995_K) {
            return true;
        }
        Vec3d origin = spell.getOriginWithFallback(world);
        if (origin == null) {
            return false;
        }
        double dist = spellRing.getAttributeValue(world, AttributeRegistry.RANGE, spell);
        double speed = spellRing.getAttributeValue(world, AttributeRegistry.SPEED, spell);
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        EntitySpellProjectile proj = new EntitySpellProjectile(world, spellRing, spell, (float)dist, (float)speed, 0.1f, !overrides.onRunProjectile(world, spell, spellRing));
        proj.func_70107_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
        proj.field_70133_I = true;
        boolean success = world.func_72838_d((Entity)proj);
        if (success) {
            world.func_184133_a(null, new BlockPos(origin), (SoundEvent)ModSounds.PROJECTILE_LAUNCH, SoundCategory.PLAYERS, 1.0f, (float)RandUtil.nextDouble(1.0, 1.5));
        }
        return success;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        overrides.onRenderProjectile(world, spell, spellRing);
    }

    @Override
    @NotNull
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Entity caster = data.getCaster(world);
        Vec3d origin = data.getOrigin(world);
        if (look == null) {
            return data;
        }
        if (caster == null) {
            return data;
        }
        if (origin == null) {
            return data;
        }
        double dist = ring.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double interpPosX = caster.field_70142_S + (caster.field_70165_t - caster.field_70142_S) * (double)partialTicks;
        double interpPosY = caster.field_70137_T + (caster.field_70163_u - caster.field_70137_T) * (double)partialTicks;
        double interpPosZ = caster.field_70136_U + (caster.field_70161_v - caster.field_70136_U) * (double)partialTicks;
        RayTraceResult result = new RayTrace(world, look, new Vec3d(interpPosX, interpPosY + (double)caster.func_70047_e(), interpPosZ), dist).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        data.processTrace(result);
        Vec3d target = data.getTarget(world);
        if (target == null) {
            return data;
        }
        RenderUtils.drawCircle(target, 0.3, true, false);
        return data;
    }

    @ModuleOverride(value="shape_projectile_run")
    public boolean onRunProjectile(World world, SpellData data, SpellRing shape) {
        return false;
    }

    @ModuleOverride(value="shape_projectile_render")
    public boolean onRenderProjectile(World world, SpellData data, SpellRing shape) {
        return false;
    }
}

