/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting.burnable;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.crafting.burnable.FireRecipe;
import com.teamwizardry.wizardry.crafting.burnable.FireRecipeLoader;
import com.teamwizardry.wizardry.crafting.mana.ManaRecipes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class FireRecipes {
    public static final FireRecipes INSTANCE = new FireRecipes();
    public static final HashMap<Ingredient, FireRecipe> RECIPES = new HashMap();

    public void loadRecipes(File directory) {
        FireRecipeLoader.INSTANCE.setDirectory(directory);
        FireRecipeLoader.INSTANCE.processRecipes(RECIPES);
    }

    public void copyMissingRecipes(File directory) {
        for (String recipeName : ManaRecipes.getResourceListing("wizardry", "fire_recipes")) {
            File file;
            if (recipeName.isEmpty() || (file = new File(directory, recipeName)).exists()) continue;
            InputStream stream = LibrarianLib.PROXY.getResource("wizardry", "fire_recipes/" + recipeName);
            if (stream == null) {
                Wizardry.LOGGER.fatal("    > SOMETHING WENT WRONG! Could not read recipe " + recipeName + " from mod jar! Report this to the devs on Github!");
                continue;
            }
            try {
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
                Wizardry.LOGGER.info("    > Fire recipe " + recipeName + " copied successfully from mod jar.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void copyAllRecipes(File directory) {
        Map modList = Loader.instance().getIndexedModList();
        for (Map.Entry entry : modList.entrySet()) {
            for (String recipeName : ManaRecipes.getResourceListing((String)entry.getKey(), "fire_recipes")) {
                if (recipeName.isEmpty()) continue;
                InputStream stream = LibrarianLib.PROXY.getResource((String)entry.getKey(), "fire_recipes/" + recipeName);
                if (stream == null) {
                    Wizardry.LOGGER.fatal("    > SOMETHING WENT WRONG! Could not read recipe " + recipeName + " from mod jar of '" + (String)entry.getKey() + "'! Report this to the devs on Github!");
                    continue;
                }
                try {
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)new File(directory, recipeName));
                    Wizardry.LOGGER.info("    > Fire recipe " + recipeName + " copied successfully from mod jar.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

