/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.init;

import com.teamwizardry.wizardry.api.capability.player.mana.DefaultManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityStorage;
import com.teamwizardry.wizardry.api.capability.player.miscdata.DefaultMiscCapability;
import com.teamwizardry.wizardry.api.capability.player.miscdata.IMiscCapability;
import com.teamwizardry.wizardry.api.capability.player.miscdata.MiscCapabilityProvider;
import com.teamwizardry.wizardry.api.capability.player.miscdata.MiscCapabilityStorage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="wizardry")
public class ModCapabilities {
    public static void preInit() {
        CapabilityManager.INSTANCE.register(IManaCapability.class, (Capability.IStorage)new ManaCapabilityStorage(), DefaultManaCapability::new);
        CapabilityManager.INSTANCE.register(IMiscCapability.class, (Capability.IStorage)new MiscCapabilityStorage(), DefaultMiscCapability::new);
    }

    @SubscribeEvent
    public static void attachEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            ManaCapabilityProvider manaCap = new ManaCapabilityProvider(new DefaultManaCapability());
            e.addCapability(new ResourceLocation("wizardry", "capability_mana"), (ICapabilityProvider)manaCap);
            MiscCapabilityProvider miscCap = new MiscCapabilityProvider(new DefaultMiscCapability());
            e.addCapability(new ResourceLocation("wizardry", "capability_misc"), (ICapabilityProvider)miscCap);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        IMiscCapability miscCap;
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        IManaCapability manaCap = ManaCapabilityProvider.getCap((Entity)event.player);
        if (manaCap != null) {
            manaCap.dataChanged((Entity)event.player);
        }
        if ((miscCap = MiscCapabilityProvider.getCap((Entity)event.player)) != null) {
            miscCap.dataChanged((Entity)event.player);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IMiscCapability miscCap;
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        IManaCapability manaCap = ManaCapabilityProvider.getCap((Entity)event.player);
        if (manaCap != null) {
            manaCap.dataChanged((Entity)event.player);
        }
        if ((miscCap = MiscCapabilityProvider.getCap((Entity)event.player)) != null) {
            miscCap.dataChanged((Entity)event.player);
        }
    }

    @SubscribeEvent
    public static void onDimChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        IMiscCapability miscCap;
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        IManaCapability manaCap = ManaCapabilityProvider.getCap((Entity)event.player);
        if (manaCap != null) {
            manaCap.dataChanged((Entity)event.player);
        }
        if ((miscCap = MiscCapabilityProvider.getCap((Entity)event.player)) != null) {
            miscCap.dataChanged((Entity)event.player);
        }
    }
}

