/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.proxy;

import com.teamwizardry.librarianlib.features.gui.provided.book.helper.PageTypes;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.arena.ArenaManager;
import com.teamwizardry.wizardry.api.capability.chunk.WizardryChunkCapability;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.api.plugin.PluginContext;
import com.teamwizardry.wizardry.api.plugin.WizardryPlugin;
import com.teamwizardry.wizardry.api.spell.ProcessData;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.client.gui.GuiHandler;
import com.teamwizardry.wizardry.client.gui.book.PageWizardryStructure;
import com.teamwizardry.wizardry.common.advancement.AchievementEvents;
import com.teamwizardry.wizardry.common.core.EventHandler;
import com.teamwizardry.wizardry.common.core.version.manifest.ManifestHandler;
import com.teamwizardry.wizardry.common.core.version.manifest.ManifestUpgrader;
import com.teamwizardry.wizardry.common.item.ItemBook;
import com.teamwizardry.wizardry.common.module.effects.ModuleEffectLeap;
import com.teamwizardry.wizardry.common.module.effects.ModuleEffectTimeSlow;
import com.teamwizardry.wizardry.common.network.PacketDevilDustFizzle;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.common.network.PacketFreezePlayer;
import com.teamwizardry.wizardry.common.network.PacketRenderLightningBolt;
import com.teamwizardry.wizardry.common.network.PacketRenderSpell;
import com.teamwizardry.wizardry.common.network.PacketSendSpellToBook;
import com.teamwizardry.wizardry.common.network.PacketSyncCooldown;
import com.teamwizardry.wizardry.common.world.underworld.WorldProviderUnderWorld;
import com.teamwizardry.wizardry.crafting.burnable.FireRecipes;
import com.teamwizardry.wizardry.crafting.mana.ManaRecipes;
import com.teamwizardry.wizardry.init.ModBiomes;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModCapabilities;
import com.teamwizardry.wizardry.init.ModEntities;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import com.teamwizardry.wizardry.init.ModStructures;
import com.teamwizardry.wizardry.init.ModTab;
import com.teamwizardry.wizardry.init.plugin.PluginLoaderContext;
import java.io.File;
import java.util.ServiceLoader;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    private File directory;
    private final PluginContext context = new PluginLoaderContext();

    public File getWizardryDirectory() {
        return this.directory;
    }

    public void setItemStackHandHandler(EnumHand hand, ItemStack stack) {
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.directory = new File(event.getModConfigurationDirectory(), "wizardry");
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            Wizardry.LOGGER.fatal("    > SOMETHING WENT WRONG! Could not create config folder!!");
        }
        new SpellData.DefaultKeys();
        ManifestUpgrader maniUpgrader = ManifestHandler.INSTANCE.startUpgrade(this.directory);
        maniUpgrader.changeCategoryName("modules", "wizmodules");
        maniUpgrader.finalizeUpgrade();
        ManifestHandler.INSTANCE.loadNewInternalManifest("wizmodules", "fluid_recipes", "fire_recipes");
        ManifestHandler.INSTANCE.loadExternalManifest(this.directory);
        ManifestHandler.INSTANCE.processComparisons(this.directory, "wizmodules", "fluid_recipes", "fire_recipes");
        new ModTab();
        ModBlocks.init();
        ModItems.init();
        ModSounds.init();
        ModPotions.init();
        ModEntities.init();
        ModCapabilities.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Wizardry.instance, (IGuiHandler)new GuiHandler());
        Wizardry.underWorld = DimensionType.register((String)"underworld", (String)"_dim", (int)ConfigValues.underworldID, WorldProviderUnderWorld.class, (boolean)false);
        DimensionManager.registerDimension((int)ConfigValues.underworldID, (DimensionType)Wizardry.underWorld);
        MinecraftForge.EVENT_BUS.register((Object)ArenaManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new WorldProviderUnderWorld());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AchievementEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ModuleEffectTimeSlow());
        MinecraftForge.EVENT_BUS.register((Object)new ModuleEffectLeap());
        MinecraftForge.EVENT_BUS.register((Object)ModBiomes.BIOME_UNDERWORLD);
        MinecraftForge.EVENT_BUS.register((Object)this);
        WizardryWorldCapability.init();
        WizardryChunkCapability.init();
        PacketHandler.register(PacketSendSpellToBook.class, (Side)Side.SERVER);
        PacketHandler.register(PacketRenderSpell.class, (Side)Side.CLIENT);
        PacketHandler.register(PacketExplode.class, (Side)Side.CLIENT);
        PacketHandler.register(PacketFreezePlayer.class, (Side)Side.CLIENT);
        PacketHandler.register(PacketRenderLightningBolt.class, (Side)Side.CLIENT);
        PacketHandler.register(PacketSyncCooldown.class, (Side)Side.CLIENT);
        PacketHandler.register(PacketDevilDustFizzle.class, (Side)Side.CLIENT);
        PageTypes.INSTANCE.registerPageProvider("wizardry_structure", PageWizardryStructure::new);
        ItemBook.BOOK = new Book("book");
        Wizardry.LOGGER.info("Initializing fairy task plugins...");
        for (WizardryPlugin plugin : ServiceLoader.load(WizardryPlugin.class)) {
            Wizardry.LOGGER.info("Initializing plugin {}", (Object)plugin.getClass().getName());
            plugin.onInit(this.context);
        }
        Wizardry.LOGGER.info("Initialization complete!");
    }

    public void init(FMLInitializationEvent event) {
        ModStructures.init();
        File recipeDirectory = new File(this.directory, "fluid_recipes");
        if (!recipeDirectory.exists() && !recipeDirectory.mkdirs()) {
            Wizardry.LOGGER.error("    > SOMETHING WENT WRONG! Could not create directory " + recipeDirectory.getPath());
        } else {
            if (ConfigValues.useInternalValues) {
                ManaRecipes.INSTANCE.copyAllRecipes(recipeDirectory);
            }
            ManaRecipes.INSTANCE.loadRecipes(recipeDirectory);
        }
        recipeDirectory = new File(this.directory, "fire_recipes");
        if (!recipeDirectory.exists() && !recipeDirectory.mkdirs()) {
            Wizardry.LOGGER.error("    > SOMETHING WENT WRONG! Could not create directory " + recipeDirectory.getPath());
        } else {
            if (ConfigValues.useInternalValues) {
                FireRecipes.INSTANCE.copyAllRecipes(recipeDirectory);
            }
            FireRecipes.INSTANCE.loadRecipes(recipeDirectory);
        }
        File moduleDirectory = new File(this.directory, "wizmodules");
        if (!moduleDirectory.exists() && !moduleDirectory.mkdirs()) {
            Wizardry.LOGGER.error("    > SOMETHING WENT WRONG! Could not create directory " + moduleDirectory.getPath());
        } else {
            ModuleRegistry.INSTANCE.loadUnprocessedModules();
            ModuleRegistry.INSTANCE.loadOverrideDefaults();
            if (ConfigValues.useInternalValues) {
                ModuleRegistry.INSTANCE.copyAllModules(moduleDirectory);
            }
            ModuleRegistry.INSTANCE.loadModules(moduleDirectory);
        }
        ProcessData.INSTANCE.registerAnnotatedDataTypes();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }
}

