/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTransportationStone
extends Block {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public BlockTransportationStone(Material material) {
        super(material);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false) && world instanceof World) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (stack != null && stack.func_77973_b() instanceof ItemWand && WizardData.get(player) != null) {
            WizardData data = WizardData.get(player);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, 0, z);
                    if (!BlockTransportationStone.testForCircle(world, pos1)) continue;
                    data.setStoneCircleLocation(pos1, world.field_73011_w.getDimension());
                    if (!world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.wizardry:transportation_stone.confirm", new Object[]{Spells.transportation.getNameForTranslationFormatted()}));
                    }
                    return true;
                }
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.wizardry:transportation_stone.invalid", new Object[0]));
            }
            return true;
        }
        return false;
    }

    public static boolean testForCircle(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76230_c()) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (world.func_180495_p(pos.func_177982_a(x, 0, z)).func_177230_c() == WizardryBlocks.transportation_stone || x == 0 && z == 0) continue;
                return false;
            }
        }
        return true;
    }
}

