/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.command;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandCastSpell
extends CommandBase {
    public String func_71517_b() {
        return Wizardry.settings.castCommandName;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "commands.wizardry:cast.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] arguments, BlockPos pos) {
        switch (arguments.length) {
            case 1: {
                return CommandCastSpell.func_71530_a((String[])arguments, (String[])Spell.getSpellNames());
            }
            case 2: {
                return CommandCastSpell.func_71530_a((String[])arguments, (String[])server.func_71213_z());
            }
        }
        return super.func_184883_a(server, sender, arguments, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] arguments) throws CommandException {
        if (arguments.length < 1) {
            throw new WrongUsageException("commands.wizardry:cast.usage", new Object[]{Wizardry.settings.castCommandName});
        }
        int i = 0;
        EntityPlayerMP caster = null;
        try {
            caster = CommandCastSpell.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException playerNotFoundException) {
            // empty catch block
        }
        Spell spell = Spell.get(arguments[i++]);
        if (spell == null) {
            throw new NumberInvalidException("commands.wizardry:cast.not_found", new Object[]{arguments[i - 1]});
        }
        boolean castAsOtherPlayer = false;
        if (i < arguments.length) {
            try {
                EntityPlayerMP entityplayermp = CommandCastSpell.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)arguments[i++]);
                if (caster != entityplayermp) {
                    castAsOtherPlayer = true;
                    caster = entityplayermp;
                }
            }
            catch (PlayerNotFoundException exception) {
                --i;
            }
        }
        if (caster == null) {
            throw new PlayerNotFoundException("You must specify which player you wish to perform this action on.", new Object[0]);
        }
        SpellModifiers modifiers = new SpellModifiers();
        if (i < arguments.length) {
            String nbt = CommandCastSpell.func_147178_a((ICommandSender)sender, (String[])arguments, (int)i++).func_150260_c();
            try {
                modifiers = SpellModifiers.fromNBT(JsonToNBT.func_180713_a((String)nbt));
            }
            catch (NBTException nbtexception) {
                throw new CommandException("commands.wizardry:cast.tag_error", new Object[]{nbtexception.getMessage()});
            }
            for (float multiplier : modifiers.getModifiers().values()) {
                if (multiplier < 0.0f) {
                    throw new NumberInvalidException("commands.generic.double.tooSmall", new Object[]{Float.valueOf(multiplier), 0});
                }
                if (!((double)multiplier > Wizardry.settings.maxSpellCommandMultiplier)) continue;
                throw new NumberInvalidException("commands.generic.double.tooBig", new Object[]{Float.valueOf(multiplier), Wizardry.settings.maxSpellCommandMultiplier});
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre((EntityLivingBase)caster, spell, modifiers, SpellCastEvent.Source.COMMAND))) {
            this.displayFailMessage(sender, spell);
            return;
        }
        WizardData data = WizardData.get((EntityPlayer)caster);
        if (spell.isContinuous) {
            if (data != null) {
                if (data.isCasting()) {
                    data.stopCastingContinuousSpell();
                } else {
                    data.startCastingContinuousSpell(spell, modifiers);
                    if (castAsOtherPlayer) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.wizardry:cast.success_remote_continuous", new Object[]{spell.getNameForTranslationFormatted(), caster.func_70005_c_()}));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.wizardry:cast.success_continuous", new Object[]{spell.getNameForTranslationFormatted()}));
                    }
                }
                return;
            }
        } else if (spell.cast(caster.field_70170_p, (EntityPlayer)caster, EnumHand.MAIN_HAND, 0, modifiers)) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)caster, spell, modifiers, SpellCastEvent.Source.COMMAND));
            if (spell.doesSpellRequirePacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), null, spell.id(), modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, caster.field_70170_p.field_73011_w.getDimension());
            }
            if (castAsOtherPlayer) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.wizardry:cast.success_remote", new Object[]{spell.getNameForTranslationFormatted(), caster.func_70005_c_()}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.wizardry:cast.success", new Object[]{spell.getNameForTranslationFormatted()}));
            }
            return;
        }
        this.displayFailMessage(sender, spell);
    }

    private void displayFailMessage(ICommandSender sender, Spell spell) {
        TextComponentTranslation message = new TextComponentTranslation("commands.wizardry:cast.fail", new Object[]{spell.getNameForTranslationFormatted()});
        message.func_150256_b().func_150238_a(TextFormatting.RED);
        sender.func_145747_a((ITextComponent)message);
    }
}

