/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.entity.construct.EntityForcefield;
import electroblob.wizardry.entity.construct.EntityFrostSigil;
import electroblob.wizardry.entity.construct.EntityHailstorm;
import electroblob.wizardry.entity.construct.EntityHammer;
import electroblob.wizardry.entity.construct.EntityHealAura;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.entity.construct.EntityLightningPulse;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.construct.EntityTornado;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityMagicSlime;
import electroblob.wizardry.entity.living.EntityPhoenix;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntitySilverfishMinion;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntitySpiderMinion;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.entity.projectile.EntityDarknessOrb;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityFirebolt;
import electroblob.wizardry.entity.projectile.EntityFirebomb;
import electroblob.wizardry.entity.projectile.EntityForceArrow;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceCharge;
import electroblob.wizardry.entity.projectile.EntityIceLance;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.entity.projectile.EntityLightningArrow;
import electroblob.wizardry.entity.projectile.EntityLightningDisc;
import electroblob.wizardry.entity.projectile.EntityMagicMissile;
import electroblob.wizardry.entity.projectile.EntityPoisonBomb;
import electroblob.wizardry.entity.projectile.EntitySmokeBomb;
import electroblob.wizardry.entity.projectile.EntitySpark;
import electroblob.wizardry.entity.projectile.EntitySparkBomb;
import electroblob.wizardry.entity.projectile.EntityThunderbolt;
import electroblob.wizardry.loot.RandomSpell;
import electroblob.wizardry.loot.WizardSpell;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.tileentity.TileEntityMagicLight;
import electroblob.wizardry.tileentity.TileEntityPlayerSave;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.ArrayList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class WizardryRegistry {
    private static final int LIVING_UPDATE_INTERVAL = 3;
    private static final int PROJECTILE_UPDATE_INTERVAL = 10;

    public static void registerLoot() {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomSpell.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new WizardSpell.Serializer());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "chests/wizard_tower"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "chests/dungeon_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "subsets/novice_wands"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "subsets/wizard_armour"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "subsets/arcane_tomes"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "subsets/wand_upgrades"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry", "entities/evil_wizard"));
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityArcaneWorkbench.class, (String)"wizardryArcaneWorkbenchTileEntity");
        GameRegistry.registerTileEntity(TileEntityStatue.class, (String)"wizardryPetrifiedStoneTileEntity");
        GameRegistry.registerTileEntity(TileEntityMagicLight.class, (String)"wizardryMagicLightTileEntity");
        GameRegistry.registerTileEntity(TileEntityTimer.class, (String)"wizardryTimerTileEntity");
        GameRegistry.registerTileEntity(TileEntityPlayerSave.class, (String)"wizardryTileEntityPlayerSave");
    }

    public static void registerEntities(Wizardry wizardry) {
        int id = 0;
        EntityRegistry.registerModEntity(EntityZombieMinion.class, (String)"zombie_minion", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityMagicMissile.class, (String)"magic_missile", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityArc.class, (String)"arc", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntitySkeletonMinion.class, (String)"skeleton_minion", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntitySparkBomb.class, (String)"spark_bomb", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpiritWolf.class, (String)"spirit_wolf", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceShard.class, (String)"ice_shard", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityBlazeMinion.class, (String)"blaze_minion", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceWraith.class, (String)"ice_wraith", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityLightningWraith.class, (String)"lightning_wraith", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityBlackHole.class, (String)"black_hole", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityShield.class, (String)"shield", (int)id++, (Object)wizardry, (int)128, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityMeteor.class, (String)"meteor", (int)id++, (Object)wizardry, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityBlizzard.class, (String)"blizzard", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityWizard.class, (String)"wizard", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityBubble.class, (String)"bubble", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)false);
        EntityRegistry.registerModEntity(EntityTornado.class, (String)"tornado", (int)id++, (Object)wizardry, (int)128, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityHammer.class, (String)"lightning_hammer", (int)id++, (Object)wizardry, (int)128, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityFirebomb.class, (String)"firebomb", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityForceOrb.class, (String)"force_orb", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowRain.class, (String)"arrow_rain", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntitySpark.class, (String)"spark", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityShadowWraith.class, (String)"shadow_wraith", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityDarknessOrb.class, (String)"darkness_orb", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpiderMinion.class, (String)"spider_minion", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityHealAura.class, (String)"healing_aura", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityFireSigil.class, (String)"fire_sigil", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityFrostSigil.class, (String)"frost_sigil", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityLightningSigil.class, (String)"lightning_sigil", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityLightningArrow.class, (String)"lightning_arrow", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityFirebolt.class, (String)"firebolt", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityPoisonBomb.class, (String)"poison_bomb", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceCharge.class, (String)"ice_charge", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityForceArrow.class, (String)"force_arrow", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityDart.class, (String)"dart", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityMagicSlime.class, (String)"magic_slime", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityForcefield.class, (String)"forcefield", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityFireRing.class, (String)"ring_of_fire", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityLightningDisc.class, (String)"lightning_disc", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityThunderbolt.class, (String)"thunderbolt", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceGiant.class, (String)"ice_giant", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpiritHorse.class, (String)"spirit_horse", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityPhoenix.class, (String)"phoenix", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntitySilverfishMinion.class, (String)"silverfish_minion", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityDecay.class, (String)"decay", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityStormElemental.class, (String)"storm_elemental", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityEarthquake.class, (String)"earthquake", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntityIceLance.class, (String)"ice_lance", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityHailstorm.class, (String)"hailstorm", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(EntitySmokeBomb.class, (String)"smoke_bomb", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityEvilWizard.class, (String)"evil_wizard", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityDecoy.class, (String)"decoy", (int)id++, (Object)wizardry, (int)128, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityIceSpike.class, (String)"ice_spike", (int)id++, (Object)wizardry, (int)128, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityLightningPulse.class, (String)"lightning_pulse", (int)id++, (Object)wizardry, (int)128, (int)10, (boolean)false);
        EntityRegistry.registerEgg(EntityWizard.class, (int)1648990, (int)15635218);
        EntityRegistry.registerEgg(EntityEvilWizard.class, (int)2688004, (int)15635218);
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_150597_n) {
            if (biome == null) continue;
            biomes.add(biome);
        }
        biomes.remove(Biomes.field_76789_p);
        biomes.remove(Biomes.field_76788_q);
        EntityRegistry.addSpawn(EntityEvilWizard.class, (int)3, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes.toArray(new Biome[biomes.size()]));
    }

    public static void registerRecipes() {
        ItemStack magicCrystalStack = new ItemStack(WizardryItems.magic_crystal);
        ItemStack magicWandStack = new ItemStack(WizardryItems.magic_wand, 1, Tier.BASIC.maxCharge);
        ItemStack goldNuggetStack = new ItemStack(Items.field_151074_bl);
        ItemStack stickStack = new ItemStack(Items.field_151055_y);
        ItemStack bookStack = new ItemStack(Items.field_151122_aG);
        ItemStack stringStack = new ItemStack(Items.field_151007_F);
        ItemStack spellBookStack = new ItemStack(WizardryItems.spell_book, 1, Spells.magic_missile.id());
        ItemStack arcaneWorkbenchStack = new ItemStack(WizardryBlocks.arcane_workbench);
        ItemStack stoneStack = new ItemStack(Blocks.field_150348_b);
        ItemStack lapisBlockStack = new ItemStack(Blocks.field_150368_y);
        ItemStack purpleCarpetStack = new ItemStack(Blocks.field_150404_cg, 1, 10);
        ItemStack wizardHandbookStack = new ItemStack(WizardryItems.wizard_handbook);
        ItemStack crystalFlowerStack = new ItemStack(WizardryBlocks.crystal_flower);
        ItemStack magicCrystalStack1 = new ItemStack(WizardryItems.magic_crystal, 2);
        ItemStack magicCrystalStack2 = new ItemStack(WizardryItems.magic_crystal, 9);
        ItemStack crystalBlockStack = new ItemStack(WizardryBlocks.crystal_block);
        ItemStack manaFlaskStack = new ItemStack(WizardryItems.mana_flask);
        ItemStack bottleStack = new ItemStack(Items.field_151069_bo);
        ItemStack gunpowderStack = new ItemStack(Items.field_151016_H);
        ItemStack blazePowderStack = new ItemStack(Items.field_151065_br);
        ItemStack spiderEyeStack = new ItemStack(Items.field_151070_bp);
        ItemStack coalStack = new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE);
        ItemStack firebombStack = new ItemStack(WizardryItems.firebomb, 3);
        ItemStack poisonBombStack = new ItemStack(WizardryItems.poison_bomb, 3);
        ItemStack smokeBombStack = new ItemStack(WizardryItems.smoke_bomb, 3);
        ItemStack transportationStoneStack = new ItemStack(WizardryBlocks.transportation_stone, 2);
        ItemStack silkStack = new ItemStack(WizardryItems.magic_silk);
        ItemStack silkStack1 = new ItemStack(WizardryItems.magic_silk, 2);
        ItemStack hatStack = new ItemStack(WizardryItems.wizard_hat);
        ItemStack robeStack = new ItemStack(WizardryItems.wizard_robe);
        ItemStack leggingsStack = new ItemStack(WizardryItems.wizard_leggings);
        ItemStack bootsStack = new ItemStack(WizardryItems.wizard_boots);
        ItemStack scrollStack = new ItemStack(WizardryItems.blank_scroll);
        ItemStack paperStack = new ItemStack(Items.field_151121_aF);
        GameRegistry.addRecipe((ItemStack)magicWandStack, (Object[])new Object[]{"  x", " y ", "z  ", Character.valueOf('x'), magicCrystalStack, Character.valueOf('y'), stickStack, Character.valueOf('z'), goldNuggetStack});
        GameRegistry.addRecipe((ItemStack)spellBookStack, (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), magicCrystalStack, Character.valueOf('y'), bookStack});
        GameRegistry.addRecipe((ItemStack)arcaneWorkbenchStack, (Object[])new Object[]{"vwv", "xyx", "zzz", Character.valueOf('v'), goldNuggetStack, Character.valueOf('w'), purpleCarpetStack, Character.valueOf('x'), magicCrystalStack, Character.valueOf('y'), lapisBlockStack, Character.valueOf('z'), stoneStack});
        GameRegistry.addRecipe((ItemStack)manaFlaskStack, (Object[])new Object[]{"yyy", "yxy", "yyy", Character.valueOf('x'), bottleStack, Character.valueOf('y'), magicCrystalStack});
        GameRegistry.addRecipe((ItemStack)transportationStoneStack, (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), stoneStack, Character.valueOf('y'), magicCrystalStack});
        GameRegistry.addRecipe((ItemStack)hatStack, (Object[])new Object[]{"yyy", "y y", Character.valueOf('y'), silkStack});
        GameRegistry.addRecipe((ItemStack)robeStack, (Object[])new Object[]{"y y", "yyy", "yyy", Character.valueOf('y'), silkStack});
        GameRegistry.addRecipe((ItemStack)leggingsStack, (Object[])new Object[]{"yyy", "y y", "y y", Character.valueOf('y'), silkStack});
        GameRegistry.addRecipe((ItemStack)bootsStack, (Object[])new Object[]{"y y", "y y", Character.valueOf('y'), silkStack});
        GameRegistry.addRecipe((ItemStack)silkStack1, (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), stringStack, Character.valueOf('y'), magicCrystalStack});
        GameRegistry.addRecipe((ItemStack)crystalBlockStack, (Object[])new Object[]{"zzz", "zzz", "zzz", Character.valueOf('z'), magicCrystalStack});
        GameRegistry.addShapelessRecipe((ItemStack)wizardHandbookStack, (Object[])new Object[]{bookStack, magicCrystalStack});
        GameRegistry.addShapelessRecipe((ItemStack)magicCrystalStack1, (Object[])new Object[]{crystalFlowerStack});
        GameRegistry.addShapelessRecipe((ItemStack)magicCrystalStack2, (Object[])new Object[]{crystalBlockStack});
        if (Wizardry.settings.firebombIsCraftable) {
            GameRegistry.addShapelessRecipe((ItemStack)firebombStack, (Object[])new Object[]{bottleStack, gunpowderStack, blazePowderStack, blazePowderStack});
        }
        if (Wizardry.settings.poisonBombIsCraftable) {
            GameRegistry.addShapelessRecipe((ItemStack)poisonBombStack, (Object[])new Object[]{bottleStack, gunpowderStack, spiderEyeStack, spiderEyeStack});
        }
        if (Wizardry.settings.smokeBombIsCraftable) {
            GameRegistry.addShapelessRecipe((ItemStack)smokeBombStack, (Object[])new Object[]{bottleStack, gunpowderStack, coalStack, coalStack});
        }
        if (Wizardry.settings.useAlternateScrollRecipe) {
            GameRegistry.addShapelessRecipe((ItemStack)scrollStack, (Object[])new Object[]{paperStack, stringStack, magicCrystalStack});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)scrollStack, (Object[])new Object[]{paperStack, stringStack});
        }
        for (Element element : Element.values()) {
            for (Tier tier : Tier.values()) {
                ItemStack miscWandStack = new ItemStack(WizardryUtilities.getWand(tier, element), 1, Short.MAX_VALUE);
                GameRegistry.addShapelessRecipe((ItemStack)miscWandStack, (Object[])new Object[]{miscWandStack, manaFlaskStack});
            }
        }
        for (Element element : Element.values()) {
            for (EntityEquipmentSlot slot : WizardryUtilities.ARMOUR_SLOTS) {
                ItemStack miscArmourStack = new ItemStack(WizardryUtilities.getArmour(element, slot), 1, Short.MAX_VALUE);
                GameRegistry.addShapelessRecipe((ItemStack)miscArmourStack, (Object[])new Object[]{miscArmourStack, manaFlaskStack});
            }
        }
    }
}

