/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlackHole
extends Spell {
    public BlackHole() {
        super(Tier.MASTER, 150, Element.SORCERY, "black_hole", SpellType.ATTACK, 400, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(10.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = new BlockPos(rayTrace.field_72307_f).func_177972_a(rayTrace.field_178784_b);
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityBlackHole(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() - 1) + 0.5, (double)pos.func_177952_p() + 0.5, (EntityLivingBase)caster, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), modifiers.get("damage")));
                }
                caster.func_184609_a(hand);
                WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187855_gD, 2.0f, 0.7f);
                return true;
            }
        } else {
            int x = (int)(Math.floor(caster.field_70165_t) + caster.func_70040_Z().field_72450_a * 8.0);
            int y = (int)(Math.floor(caster.field_70163_u) + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * 8.0);
            int z = (int)(Math.floor(caster.field_70161_v) + caster.func_70040_Z().field_72449_c * 8.0);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityBlackHole(world, x, y, z, (EntityLivingBase)caster, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), modifiers.get("damage")));
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187855_gD, 2.0f, 0.7f);
            return true;
        }
        return false;
    }
}

