/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ChainLightning
extends Spell {
    public ChainLightning() {
        super(Tier.ADVANCED, 25, Element.LIGHTNING, "chain_lightning", SpellType.ATTACK, 50, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade), 8.0f);
        if (rayTrace != null && rayTrace.field_72308_g != null && rayTrace.field_72308_g instanceof EntityLivingBase) {
            Entity target = rayTrace.field_72308_g;
            if (!world.field_72995_K) {
                EntityArc arc = new EntityArc(world);
                arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + (double)(caster.field_70131_O / 2.0f), caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                world.func_72838_d((Entity)arc);
            } else {
                for (int i = 0; i < 8; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            target.func_184185_a(WizardrySounds.SPELL_SPARK, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                }
            } else {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 10.0f * modifiers.get("damage"));
            }
            double seekerRange = 5.0;
            List<EntityLivingBase> secondaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, world);
            for (int i = 0; i < Math.min(secondaryTargets.size(), 5); ++i) {
                EntityLivingBase secondaryTarget = secondaryTargets.get(i);
                if (secondaryTarget == target || !WizardryUtilities.isValidTarget((Entity)caster, (Entity)secondaryTarget)) continue;
                if (!world.field_72995_K) {
                    EntityArc arc = new EntityArc(world);
                    arc.setEndpointCoords(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                    world.func_72838_d((Entity)arc);
                } else {
                    for (int j = 0; j < 8; ++j) {
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, secondaryTarget.func_174813_aQ().field_72338_b + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, secondaryTarget.func_174813_aQ().field_72338_b + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                secondaryTarget.func_184185_a(WizardrySounds.SPELL_SPARK, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, (Entity)secondaryTarget)) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{secondaryTarget.func_70005_c_(), this.getNameForTranslationFormatted()}));
                    }
                } else {
                    secondaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 8.0f * modifiers.get("damage"));
                }
                List<EntityLivingBase> tertiaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                for (int j = 0; j < Math.min(tertiaryTargets.size(), 2); ++j) {
                    EntityLivingBase tertiaryTarget = tertiaryTargets.get(j);
                    if (tertiaryTarget == target || secondaryTargets.contains(tertiaryTarget) || !WizardryUtilities.isValidTarget((Entity)caster, (Entity)tertiaryTarget)) continue;
                    if (!world.field_72995_K) {
                        EntityArc arc = new EntityArc(world);
                        arc.setEndpointCoords(secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, tertiaryTarget.field_70165_t, tertiaryTarget.field_70163_u + (double)(tertiaryTarget.field_70131_O / 2.0f), tertiaryTarget.field_70161_v);
                        world.func_72838_d((Entity)arc);
                    } else {
                        for (int k = 0; k < 8; ++k) {
                            Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, tertiaryTarget.func_174813_aQ().field_72338_b + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, tertiaryTarget.func_174813_aQ().field_72338_b + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                    tertiaryTarget.func_184185_a(WizardrySounds.SPELL_SPARK, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, (Entity)tertiaryTarget)) {
                        if (world.field_72995_K) continue;
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{tertiaryTarget.func_70005_c_(), this.getNameForTranslationFormatted()}));
                        continue;
                    }
                    tertiaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 6.0f * modifiers.get("damage"));
                }
            }
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }
}

