/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class CurseOfSoulbinding
extends Spell {
    public CurseOfSoulbinding() {
        super(Tier.ADVANCED, 35, Element.NECROMANCY, "curse_of_soulbinding", SpellType.ATTACK, 100, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase && WizardData.get(caster) != null) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (!WizardData.get(caster).soulbind(target)) {
                return false;
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.4f, 0.0f, 0.0f);
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.1f, 0.0f, 0.0f);
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 1.0f, 0.8f, 1.0f);
            }
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187855_gD, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        WizardData data;
        if (!(event.getEntity().field_70170_p.field_72995_K || !(event.getEntityLiving() instanceof EntityPlayer) || event.getSource().func_76363_c() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory() || (data = WizardData.get((EntityPlayer)event.getEntityLiving())) == null)) {
            data.damageAllSoulboundCreatures(event.getAmount());
        }
    }
}

