/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class FrostRay
extends Spell {
    public FrostRay() {
        super(Tier.APPRENTICE, 5, Element.ICE, "frost_ray", SpellType.ATTACK, 0, EnumAction.NONE, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                if (!world.field_72995_K && ticksInUse == 1) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                }
            } else {
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(200.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                float baseDamage = target instanceof EntityBlaze || target instanceof EntityMagmaCube ? 6.0f : 3.0f;
                WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FROST), baseDamage * modifiers.get("damage"));
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, look.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 8 + world.field_73012_v.nextInt(12), 0.4f, 0.6f, 1.0f);
                x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, look.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 8 + world.field_73012_v.nextInt(12), 1.0f, 1.0f, 1.0f);
            }
        }
        if (ticksInUse % 12 == 0) {
            if (ticksInUse == 0) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 0.5f, 1.0f);
            }
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_ICE, 0.5f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            Vec3d vec = new Vec3d(target.field_70165_t - caster.field_70165_t, target.field_70163_u - caster.field_70163_u, target.field_70161_v - caster.field_70161_v).func_72432_b();
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(200.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                float baseDamage = target instanceof EntityBlaze || target instanceof EntityMagmaCube ? 6.0f : 3.0f;
                WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FROST), baseDamage * modifiers.get("damage"));
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 20; ++i) {
                    double x1 = caster.field_70165_t + vec.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + vec.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double z1 = caster.field_70161_v + vec.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, vec.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), vec.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), vec.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 8 + world.field_73012_v.nextInt(12), 0.4f, 0.6f, 1.0f);
                    x1 = caster.field_70165_t + vec.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + vec.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    z1 = caster.field_70161_v + vec.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, vec.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), vec.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), vec.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 8 + world.field_73012_v.nextInt(12), 1.0f, 1.0f, 1.0f);
                }
            }
            if (ticksInUse % 12 == 0) {
                if (ticksInUse == 0) {
                    caster.func_184185_a(WizardrySounds.SPELL_ICE, 0.5f, 1.0f);
                }
                caster.func_184185_a(WizardrySounds.SPELL_LOOP_ICE, 0.5f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

