/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryAchievements;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class IceStatue
extends Spell {
    private static final int baseDuration = 400;

    public IceStatue() {
        super(Tier.APPRENTICE, 15, Element.ICE, "ice_statue", SpellType.ATTACK, 40, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLiving && !world.field_72995_K) {
            EntityLiving target = (EntityLiving)rayTrace.field_72308_g;
            BlockPos pos = new BlockPos((Entity)target);
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            target.field_70737_aN = 0;
            if (target instanceof EntityBlaze) {
                caster.func_71064_a((StatBase)WizardryAchievements.freeze_blaze, 1);
            }
            if (((double)target.field_70131_O < 1.2 || target.func_70631_g_()) && WizardryUtilities.canBlockBeReplaced(world, pos)) {
                world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(target, 1, 1);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                target.func_70106_y();
                target.func_184185_a(WizardrySounds.SPELL_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            } else if ((double)target.field_70131_O < 2.5 && WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
                world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(target, 1, 2);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                world.func_175656_a(pos.func_177984_a(), WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart(target, 2, 2);
                }
                target.func_70106_y();
                target.func_184185_a(WizardrySounds.SPELL_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            } else if (WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a()) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177981_b(2))) {
                world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart(target, 1, 3);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                world.func_175656_a(pos.func_177984_a(), WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart(target, 2, 3);
                }
                world.func_175656_a(pos.func_177981_b(2), WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos.func_177981_b(2)) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177981_b(2))).setCreatureAndPart(target, 3, 3);
                }
                target.func_70106_y();
                target.func_184185_a(WizardrySounds.SPELL_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                Wizardry.proxy.spawnParticle(WizardryParticleType.SNOW, world, x1, y1, z1, 0.0, -0.02, 0.0, 20 + world.field_73012_v.nextInt(10));
            }
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
        return true;
    }
}

