/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Ignite
extends Spell {
    public Ignite() {
        super(Tier.BASIC, 5, Element.FIRE, "ignite", SpellType.ATTACK, 10, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos;
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                }
            } else {
                target.func_70015_d((int)(10.0f * modifiers.get(WizardryItems.duration_upgrade)));
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187649_bu, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        rayTrace = WizardryUtilities.rayTrace(10.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175623_d(pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b))) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
            if (world.field_72995_K) {
                double dx = (double)pos.func_177958_n() + 0.5 - caster.field_70165_t;
                double dy = (double)pos.func_177956_o() + 0.5 - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = (double)pos.func_177952_p() + 0.5 - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187649_bu, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
                target.func_70015_d((int)(10.0f * modifiers.get(WizardryItems.duration_upgrade)));
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (caster.field_70163_u + (double)caster.func_70047_e());
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(SoundEvents.field_187649_bu, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

