/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Intimidate
extends Spell {
    public static final String NBT_KEY = "fearedEntity";

    public Intimidate() {
        super(Tier.APPRENTICE, 20, Element.NECROMANCY, "intimidate", SpellType.ATTACK, 100, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            List<EntityCreature> entities = WizardryUtilities.getEntitiesWithinRadius(8.0f * modifiers.get(WizardryItems.range_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityCreature.class);
            for (EntityCreature target : entities) {
                Intimidate.runAway(target, (EntityLivingBase)caster);
                NBTTagCompound entityNBT = target.getEntityData();
                if (entityNBT != null) {
                    entityNBT.func_186854_a(NBT_KEY, caster.func_110124_au());
                }
                target.func_70690_d(new PotionEffect(WizardryPotions.fear, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
            }
        } else {
            for (int i = 0; i < 30; ++i) {
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, caster.field_70165_t - 1.0 + world.field_73012_v.nextDouble() * 2.0, caster.func_174813_aQ().field_72338_b + 1.5 + world.field_73012_v.nextDouble() * 0.5, caster.field_70161_v - 1.0 + world.field_73012_v.nextDouble() * 2.0, 0.0, 0.0, 0.0, 0, 0.9f, 0.1f, 0.0f);
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187525_aO, 1.0f, 1.0f);
        return true;
    }

    public static boolean runAway(EntityCreature target, EntityLivingBase caster) {
        if (target.func_70032_d((Entity)caster) < 16.0f) {
            PathPoint point;
            Vec3d Vec3d2 = RandomPositionGenerator.func_75461_b((EntityCreature)target, (int)16, (int)7, (Vec3d)new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v));
            if (Vec3d2 == null) {
                return false;
            }
            boolean flag = true;
            if (!target.func_70661_as().func_75500_f() && (point = target.func_70661_as().func_75505_d().func_75870_c()) != null) {
                flag = caster.func_70011_f((double)point.field_75839_a, (double)point.field_75837_b, (double)point.field_75838_c) < 16.0;
            }
            target.func_70624_b(null);
            if (flag) {
                return target.func_70661_as().func_75492_a(Vec3d2.field_72450_a, Vec3d2.field_72448_b, Vec3d2.field_72449_c, 1.25);
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a(WizardryPotions.fear) && event.getEntityLiving() instanceof EntityCreature) {
            Entity caster;
            NBTTagCompound entityNBT = event.getEntityLiving().getEntityData();
            EntityCreature creature = (EntityCreature)event.getEntityLiving();
            if (entityNBT != null && entityNBT.func_74764_b(NBT_KEY) && (caster = WizardryUtilities.getEntityByUUID(creature.field_70170_p, entityNBT.func_186857_a(NBT_KEY))) instanceof EntityLivingBase) {
                Intimidate.runAway(creature, (EntityLivingBase)caster);
            }
        }
    }
}

