/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Metamorphosis
extends Spell {
    public Metamorphosis() {
        super(Tier.APPRENTICE, 15, Element.NECROMANCY, "metamorphosis", SpellType.UTILITY, 30, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72308_g != null && rayTrace.field_72308_g instanceof EntityLivingBase) {
            Entity entityHit = rayTrace.field_72308_g;
            double xPos = entityHit.field_70165_t;
            double yPos = entityHit.field_70163_u;
            double zPos = entityHit.field_70161_v;
            EntityPigZombie newEntity = null;
            boolean flag = false;
            if (entityHit instanceof EntityPig) {
                newEntity = new EntityPigZombie(world);
            } else if (entityHit instanceof EntityPigZombie) {
                newEntity = new EntityPig(world);
            } else if (entityHit instanceof EntitySkeleton) {
                if (((EntitySkeleton)entityHit).func_189771_df() == SkeletonType.NORMAL) {
                    ((EntitySkeleton)entityHit).func_189768_a(SkeletonType.WITHER);
                } else {
                    ((EntitySkeleton)entityHit).func_189768_a(SkeletonType.NORMAL);
                }
                flag = true;
            } else if (entityHit instanceof EntityCow && !(entityHit instanceof EntityMooshroom)) {
                newEntity = new EntityMooshroom(world);
            } else if (entityHit instanceof EntityMooshroom) {
                newEntity = new EntityCow(world);
            } else if (entityHit instanceof EntityChicken) {
                newEntity = new EntityBat(world);
            } else if (entityHit instanceof EntityBat) {
                newEntity = new EntityChicken(world);
            } else if (entityHit instanceof EntitySlime && !(entityHit instanceof EntityMagmaCube)) {
                newEntity = new EntityMagmaCube(world);
            } else if (entityHit instanceof EntityMagmaCube) {
                newEntity = new EntitySlime(world);
            } else if (entityHit instanceof EntitySpider && !(entityHit instanceof EntityCaveSpider)) {
                newEntity = new EntityCaveSpider(world);
            } else if (entityHit instanceof EntityCaveSpider) {
                newEntity = new EntitySpider(world);
            }
            if (newEntity != null || flag) {
                if (!world.field_72995_K && newEntity != null) {
                    newEntity.func_70606_j(((EntityLiving)entityHit).func_110143_aJ());
                    entityHit.func_70106_y();
                    newEntity.func_70107_b(xPos, yPos, zPos);
                    world.func_72838_d((Entity)newEntity);
                }
                if (world.field_72995_K) {
                    int i;
                    for (i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                        double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                        double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                        double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 0.2f, 0.0f, 0.1f);
                    }
                    for (i = 0; i < 5; ++i) {
                        Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, xPos, yPos, zPos, 0.0, 0.0, 0.0, 0, 0.1f, 0.0f, 0.0f);
                    }
                }
                caster.func_184609_a(hand);
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_DEFLECTION, 0.5f, 0.8f);
                return true;
            }
        }
        return false;
    }
}

