/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class PlagueOfDarkness
extends Spell {
    public PlagueOfDarkness() {
        super(Tier.MASTER, 75, Element.NECROMANCY, "plague_of_darkness", SpellType.ATTACK, 200, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(5.0 * (double)modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target) || MagicDamage.isEntityImmune(MagicDamage.DamageType.WITHER, (Entity)target)) continue;
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.WITHER), 8.0f * modifiers.get("damage"));
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(140.0f * modifiers.get(WizardryItems.duration_upgrade)), 2));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, 0, 0.1f, 0.0f, 0.0f);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, 30, 0.1f, 0.0f, 0.05f);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                if (block != null) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174813_aQ().field_72338_b, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
                }
                ++i;
            }
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187849_gA, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }
}

