/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ShadowWard
extends Spell {
    public ShadowWard() {
        super(Tier.ADVANCED, 10, Element.NECROMANCY, "shadow_ward", SpellType.DEFENCE, 0, EnumAction.BLOCK, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            double dx = -1.0f + 2.0f * world.field_73012_v.nextFloat();
            double dy = -1.0f + world.field_73012_v.nextFloat();
            double dz = -1.0f + 2.0f * world.field_73012_v.nextFloat();
            world.func_175688_a(EnumParticleTypes.PORTAL, caster.field_70165_t, WizardryUtilities.getPlayerEyesPos(caster), caster.field_70161_v, dx, dy, dz, new int[0]);
        }
        if (ticksInUse % 50 == 0) {
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187810_eg, 0.6f, 1.5f);
        }
        return true;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        ItemStack wand;
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && (wand = event.getEntityLiving().func_184607_cu()) != null && wand.func_77952_i() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof ShadowWard && !event.getSource().func_76363_c() && (!(event.getSource() instanceof IElementalDamage) || !((IElementalDamage)event.getSource()).isRetaliatory())) {
            event.setCanceled(true);
            event.getEntityLiving().func_70097_a(MagicDamage.causeDirectMagicDamage(event.getSource().func_76346_g(), MagicDamage.DamageType.MAGIC, true), event.getAmount() / 2.0f);
            ((EntityLivingBase)event.getSource().func_76346_g()).func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)event.getEntityLiving(), MagicDamage.DamageType.MAGIC, true), event.getAmount() / 2.0f);
        }
    }
}

