/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.block.BlockTransportationStone;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Transportation
extends Spell {
    public Transportation() {
        super(Tier.ADVANCED, 100, Element.SORCERY, "transportation", SpellType.UTILITY, 100, EnumAction.BOW, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData properties = WizardData.get(caster);
        if (world.field_72995_K) {
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187814_ei, 1.0f, 1.0f);
        }
        if (properties != null && properties.getTpCountdown() == 0) {
            if (caster.field_71093_bK == properties.getStoneCircleDimension()) {
                if (properties.getStoneCircleLocation() != null) {
                    if (BlockTransportationStone.testForCircle(world, properties.getStoneCircleLocation())) {
                        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187814_ei, 1.0f, 1.0f);
                        caster.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0));
                        properties.setTpCountdown(75);
                        return true;
                    }
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.transportation.missing", new Object[0]));
                    }
                } else if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.transportation.undefined", new Object[0]));
                }
            } else if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.transportation.wrongdimension", new Object[0]));
            }
        }
        return false;
    }
}

