/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAchievements;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public final class WizardryEventHandler {
    private static final String[] LOOT_INJECTION_LOCATIONS = new String[]{"minecraft:chests/simple_dungeon", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion", "minecraft:chests/end_city_treasure"};

    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        if (Wizardry.settings.generateLoot) {
            for (String location : LOOT_INJECTION_LOCATIONS) {
                if (!event.getName().toString().matches(location)) continue;
                event.getTable().addPool(WizardryEventHandler.getAdditive("wizardry:chests/dungeon_additions"));
            }
        }
    }

    private static LootPool getAdditive(String entryName) {
        return new LootPool(new LootEntry[]{WizardryEventHandler.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "wizardry_additive_pool");
    }

    private static LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "wizardry_additive_entry");
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            SpellGlyphData.get(event.player.field_70170_p).sync((EntityPlayerMP)event.player);
            Wizardry.settings.sync((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (!event.getSpell().isEnabled()) {
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                event.getEntity().func_145747_a((ITextComponent)new TextComponentTranslation("spell.disabled", new Object[]{event.getSpell().getNameForTranslationFormatted()}));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        EntityPlayer player;
        WizardData data;
        if (event.getEntity() instanceof EntityPlayer && (data = WizardData.get(player = (EntityPlayer)event.getEntity())) != null && !MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent(player, event.getSpell(), DiscoverSpellEvent.Source.CASTING)) && data.discoverSpell(event.getSpell())) {
            if (event.getSource() == SpellCastEvent.Source.COMMAND) {
                if (!event.getSpell().doesSpellRequirePacket()) {
                    data.sync();
                }
            } else if (!event.getEntity().field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d && Wizardry.settings.discoveryMode) {
                WizardryUtilities.playSoundAtPlayer(player, SoundEvents.field_187802_ec, 1.25f, 1.0f);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{event.getSpell().getNameForTranslationFormatted()}));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (!Wizardry.settings.friendlyFire && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityPlayer && event.getSource() instanceof IElementalDamage && WizardryUtilities.isPlayerAlly((EntityPlayer)event.getSource().func_76346_g(), (EntityPlayer)event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        if (!(event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || event.getSource().func_76352_a() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory())) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            World world = event.getEntityLiving().field_70170_p;
            if (event.getEntityLiving().func_70644_a(WizardryPotions.fireskin) && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)event.getEntityLiving())) {
                attacker.func_70015_d(5);
            }
            if (event.getEntityLiving().func_70644_a(WizardryPotions.ice_shroud) && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.getEntityLiving())) {
                attacker.func_70690_d(new PotionEffect(WizardryPotions.frost, 100, 0));
            }
            if (event.getEntityLiving().func_70644_a(WizardryPotions.static_aura)) {
                if (!world.field_72995_K) {
                    EntityArc arc = new EntityArc(world);
                    arc.setEndpointCoords(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + 1.0, event.getEntityLiving().field_70161_v, attacker.field_70165_t, attacker.field_70163_u + (double)(attacker.field_70131_O / 2.0f), attacker.field_70161_v);
                    world.func_72838_d((Entity)arc);
                } else {
                    for (int i = 0; i < 8; ++i) {
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, attacker.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, attacker.func_174813_aQ().field_72338_b + (double)(attacker.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, attacker.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, attacker.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, attacker.func_174813_aQ().field_72338_b + (double)(attacker.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, attacker.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                attacker.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)event.getEntityLiving(), MagicDamage.DamageType.SHOCK, true), 4.0f);
                attacker.func_184185_a(WizardrySounds.SPELL_SPARK, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        int level;
        EntityLivingBase attacker;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && attacker.func_184614_ca().func_77973_b() instanceof ItemSword) {
            int level2 = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.flaming_weapon, (ItemStack)attacker.func_184614_ca());
            if (level2 > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)event.getEntityLiving())) {
                event.getEntityLiving().func_70015_d(level2 * 4);
            }
            if ((level2 = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.freezing_weapon, (ItemStack)attacker.func_184614_ca())) > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.getEntityLiving())) {
                event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.frost, level2 * 200, 0));
            }
        }
        if (event.getSource().func_76364_f() instanceof EntityArrow && event.getSource().func_76364_f().getEntityData() != null && (level = event.getSource().func_76364_f().getEntityData().func_74762_e("frostLevel")) > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.getEntityLiving())) {
            event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.frost, level * 150, 0));
        }
        if (event.getSource() != null && event.getSource() instanceof IElementalDamage) {
            if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                event.setAmount((float)((double)event.getAmount() * Wizardry.settings.playerDamageScale));
            } else {
                event.setAmount((float)((double)event.getAmount() * Wizardry.settings.npcDamageScale));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            InventoryCrafting craftMatrix;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K) {
                WizardryEventHandler.hackilyFixContinuousSpellCasting(player);
            }
            if (player.field_71070_bA instanceof ContainerWorkbench) {
                craftMatrix = ((ContainerWorkbench)player.field_71070_bA).field_75162_e;
                ItemStack output = ((ContainerWorkbench)player.field_71070_bA).field_75160_f.func_70301_a(0);
                WizardryEventHandler.processManaFlaskCrafting((IInventory)craftMatrix, output);
            } else if (player.field_71070_bA instanceof ContainerPlayer) {
                craftMatrix = ((ContainerPlayer)player.field_71070_bA).field_75181_e;
                ItemStack output = ((ContainerPlayer)player.field_71070_bA).field_75179_f.func_70301_a(0);
                WizardryEventHandler.processManaFlaskCrafting((IInventory)craftMatrix, output);
            }
        }
        if (event.getEntityLiving().field_70170_p.field_72995_K && event.getEntity() instanceof ISpellCaster && event.getEntity() instanceof EntityLiving) {
            Spell spell = ((ISpellCaster)event.getEntity()).getContinuousSpell();
            SpellModifiers modifiers = ((ISpellCaster)event.getEntity()).getModifiers();
            if (spell != null && spell != Spells.none && !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(event.getEntityLiving(), spell, modifiers, SpellCastEvent.Source.NPC, 0))) {
                spell.cast(event.getEntity().field_70170_p, (EntityLiving)event.getEntity(), EnumHand.MAIN_HAND, 0, ((EntityLiving)event.getEntity()).func_70638_az(), modifiers);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            for (ItemStack stack : WizardryUtilities.getPrioritisedHotbarAndOffhand(player)) {
                if (!(stack.func_77973_b() instanceof ItemWand) || !stack.func_77951_h() || WandHelper.getUpgradeLevel(stack, WizardryItems.siphon_upgrade) <= 0) continue;
                int damage = stack.func_77952_i() - 3 * WandHelper.getUpgradeLevel(stack, WizardryItems.siphon_upgrade) - player.field_70170_p.field_73012_v.nextInt(3);
                if (damage < 0) {
                    damage = 0;
                }
                stack.func_77964_b(damage);
                break;
            }
            if (event.getEntityLiving() == player && event.getSource() instanceof IElementalDamage) {
                player.func_71029_a((StatBase)WizardryAchievements.self_destruct);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        int rareDropNumber;
        if (event.getEntityLiving() instanceof IMob && !(event.getEntityLiving() instanceof EntityEvilWizard) && !(event.getEntityLiving() instanceof ISummonedCreature) && event.getSource().func_76346_g() instanceof EntityPlayer && Wizardry.settings.spellBookDropChance > 0 && (rareDropNumber = event.getEntity().field_70170_p.field_73012_v.nextInt(200) - event.getLootingLevel()) < Wizardry.settings.spellBookDropChance) {
            int id = WizardryUtilities.getStandardWeightedRandomSpellId(event.getEntity().field_70170_p.field_73012_v);
            event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(WizardryItems.spell_book, 1, id)));
        }
    }

    @SubscribeEvent
    public static void onItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getItem().func_92059_d().func_77973_b() == WizardryItems.magic_crystal) {
            event.getEntityPlayer().func_71064_a((StatBase)WizardryAchievements.crystal, 1);
        }
    }

    private static void hackilyFixContinuousSpellCasting(EntityPlayer player) {
        if (player.func_184587_cr() && player.func_184586_b(player.func_184600_cs()).func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell((ItemStack)player.func_184586_b((EnumHand)player.func_184600_cs())).isContinuous && player.func_184607_cu() != player.func_184586_b(player.func_184600_cs())) {
            player.func_184611_a(player.func_184600_cs(), player.func_184607_cu());
        }
    }

    private static void processManaFlaskCrafting(IInventory craftMatrix, ItemStack output) {
        boolean flag = false;
        ItemStack wand = ItemStack.field_190927_a;
        ItemStack armour = ItemStack.field_190927_a;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack itemstack = craftMatrix.func_70301_a(i);
            if (itemstack.func_77973_b() == WizardryItems.mana_flask) {
                flag = true;
            }
            if (itemstack.func_77973_b() instanceof ItemWand) {
                wand = itemstack;
            }
            if (!(itemstack.func_77973_b() instanceof ItemWizardArmour)) continue;
            armour = itemstack;
        }
        if (output.func_77973_b() instanceof ItemWand && flag && !wand.func_190926_b()) {
            output.func_77982_d(wand.func_77978_p());
            if (wand.func_77952_i() - 700 < 0) {
                output.func_77964_b(0);
            } else {
                output.func_77964_b(wand.func_77952_i() - 700);
            }
        }
        if (output.func_77973_b() instanceof ItemWizardArmour && flag && !armour.func_190926_b()) {
            output.func_77982_d(armour.func_77978_p());
            if (armour.func_77952_i() - 700 < 0) {
                output.func_77964_b(0);
            } else {
                output.func_77964_b(wand.func_77952_i() - 700);
            }
        }
    }
}

