/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.enchantment;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryEnchantments;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public interface Imbuement {
    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        for (EntityItem item : event.getDrops()) {
            Imbuement.removeImbuements(item.func_92059_d());
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) {
        Imbuement.removeImbuements(event.getEntityItem().func_92059_d());
    }

    public static void removeImbuements(ItemStack stack) {
        if (stack.func_77948_v()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchantments.entrySet().removeIf(entry -> entry.getKey() instanceof Imbuement);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainerEvent(PlayerContainerEvent event) {
        if (event.getContainer() instanceof ContainerChest) {
            for (Slot slot : event.getContainer().field_75151_b) {
                Map enchantments;
                if (!(slot.func_75211_c().func_77973_b() instanceof ItemEnchantedBook) || !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)slot.func_75211_c())).keySet().removeIf(e -> e instanceof Imbuement)) continue;
                if (enchantments.isEmpty()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                    Wizardry.logger.info("Deleted enchanted book with illegal enchantments");
                    continue;
                }
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)slot.func_75211_c());
                Wizardry.logger.info("Removed illegal enchantments from enchanted book");
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase archer = (EntityLivingBase)arrow.field_70250_c;
                ItemStack bow = archer.func_184614_ca();
                if (!(bow.func_77973_b() instanceof ItemBow) && !((bow = archer.func_184592_cb()).func_77973_b() instanceof ItemBow)) {
                    return;
                }
                int level = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.magic_bow, (ItemStack)bow);
                if (level > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() + (double)level * 0.5 + 0.5);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.flaming_weapon, (ItemStack)bow) > 0) {
                    arrow.func_70015_d(100);
                }
                if ((level = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.freezing_weapon, (ItemStack)bow)) > 0 && arrow.getEntityData() != null) {
                    arrow.getEntityData().func_74768_a("frostLevel", level);
                }
            }
        }
    }
}

