/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.registry.WizardryAchievements;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityTornado
extends EntityMagicConstruct {
    private double velX;
    private double velZ;

    public EntityTornado(World world) {
        super(world);
        this.field_70131_O = 8.0f;
        this.field_70130_N = 5.0f;
        this.field_70178_ae = false;
    }

    public EntityTornado(World world, double x, double y, double z, EntityLivingBase caster, int lifetime, double velX, double velZ, float damageMultiplier) {
        super(world, x, y, z, caster, lifetime, damageMultiplier);
        this.field_70131_O = 8.0f;
        this.field_70130_N = 5.0f;
        this.velX = velX;
        this.velZ = velZ;
        this.field_70178_ae = false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 120 == 1 && this.field_70170_p.field_72995_K) {
            Wizardry.proxy.playMovingSound(this, WizardrySounds.SPELL_LOOP_WIND, 1.0f, 1.0f, false);
        }
        this.func_70091_d(MoverType.SELF, this.velX, this.field_70181_x, this.velZ);
        BlockPos pos = new BlockPos((Entity)this);
        int y = WizardryUtilities.getNearestFloorLevelC(this.field_70170_p, pos.func_177981_b(3), 5);
        pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151587_i) {
            this.func_70015_d(5);
        }
        if (!this.field_70170_p.field_72995_K) {
            List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(4.0, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
            for (EntityLivingBase target : targets) {
                double dz;
                if (!this.isValidTarget((Entity)target)) continue;
                double velY = target.field_70181_x;
                double dx = this.field_70165_t - target.field_70165_t > 0.0 ? 0.5 - (this.field_70165_t - target.field_70165_t) / 8.0 : -0.5 - (this.field_70165_t - target.field_70165_t) / 8.0;
                double d = dz = this.field_70161_v - target.field_70161_v > 0.0 ? 0.5 - (this.field_70161_v - target.field_70161_v) / 8.0 : -0.5 - (this.field_70161_v - target.field_70161_v) / 8.0;
                if (this.func_70027_ad()) {
                    target.func_70015_d(4);
                }
                if (this.getCaster() != null) {
                    target.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.MAGIC), 1.0f * this.damageMultiplier);
                } else {
                    target.func_70097_a(DamageSource.field_76376_m, 1.0f * this.damageMultiplier);
                }
                target.field_70159_w = dx;
                target.field_70181_x = velY + 0.2;
                target.field_70179_y = dz;
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
                }
                if (!(target instanceof EntityPig) || !(WizardryUtilities.getRider((Entity)target) instanceof EntityPlayer)) continue;
                ((EntityPlayer)WizardryUtilities.getRider((Entity)target)).func_71029_a((StatBase)WizardryAchievements.pig_tornado);
            }
        } else {
            for (int i = 1; i < 10; ++i) {
                double yPos1;
                double yPos = this.field_70146_Z.nextDouble() * 8.0;
                int blockX = (int)this.field_70165_t - 2 + this.field_70146_Z.nextInt(4);
                int blockZ = (int)this.field_70161_v - 2 + this.field_70146_Z.nextInt(4);
                BlockPos pos1 = new BlockPos((double)blockX, this.field_70163_u + 3.0, (double)blockZ);
                int blockY = WizardryUtilities.getNearestFloorLevelC(this.field_70170_p, pos1, 5) - 1;
                IBlockState block = this.field_70170_p.func_180495_p(pos1 = new BlockPos(pos1.func_177958_n(), blockY, pos1.func_177952_p()));
                if (!EntityTornado.canTornadoPickUpBitsOf(block)) {
                    block = this.field_70170_p.func_180494_b((BlockPos)pos1).field_76752_A;
                }
                Wizardry.proxy.spawnTornadoParticle(this.field_70170_p, this.field_70165_t, this.field_70163_u + yPos, this.field_70161_v, this.velX, this.velZ, yPos / 3.0 + 0.5, 100, block, pos1);
                Wizardry.proxy.spawnTornadoParticle(this.field_70170_p, this.field_70165_t, this.field_70163_u + yPos, this.field_70161_v, this.velX, this.velZ, yPos / 3.0 + 0.5, 100, block, pos1);
                if (block.func_185904_a() == Material.field_151584_j && this.field_70146_Z.nextInt(3) == 0) {
                    yPos1 = this.field_70146_Z.nextDouble() * 8.0;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.LEAF, this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (yPos1 / 3.0 + 0.5), this.field_70163_u + yPos1, this.field_70161_v + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (yPos1 / 3.0 + 0.5), 0.0, -0.05, 0.0, 40 + this.field_70146_Z.nextInt(10));
                }
                if (block.func_185904_a() != Material.field_151597_y && (block.func_185904_a() != Material.field_151596_z || this.field_70146_Z.nextInt(3) != 0)) continue;
                yPos1 = this.field_70146_Z.nextDouble() * 8.0;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SNOW, this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (yPos1 / 3.0 + 0.5), this.field_70163_u + yPos1, this.field_70161_v + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (yPos1 / 3.0 + 0.5), 0.0, -0.02, 0.0, 40 + this.field_70146_Z.nextInt(10));
            }
        }
    }

    private static boolean canTornadoPickUpBitsOf(IBlockState block) {
        Material material = block.func_185904_a();
        return material == Material.field_151596_z || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151587_i || material == Material.field_151595_p || material == Material.field_151597_y || material == Material.field_151586_h || material == Material.field_151585_k || material == Material.field_151584_j || material == Material.field_151582_l;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.velX = nbttagcompound.func_74769_h("velX");
        this.velZ = nbttagcompound.func_74769_h("velZ");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74780_a("velX", this.velX);
        nbttagcompound.func_74780_a("velZ", this.velZ);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeDouble(this.velX);
        data.writeDouble(this.velZ);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.velX = data.readDouble();
        this.velZ = data.readDouble();
    }
}

