/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISummonedCreature;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class EntitySummonedCreature
extends EntityCreature
implements ISummonedCreature {
    private int lifetime = 600;
    private WeakReference<EntityLivingBase> casterReference;
    private UUID casterUUID;

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public WeakReference<EntityLivingBase> getCasterReference() {
        return this.casterReference;
    }

    @Override
    public void setCasterReference(WeakReference<EntityLivingBase> reference) {
        this.casterReference = reference;
    }

    @Override
    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    @Override
    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public EntitySummonedCreature(World world) {
        super(world);
        this.field_70728_aV = 0;
    }

    public EntitySummonedCreature(World world, double x, double y, double z, EntityLivingBase caster, int lifetime) {
        super(world);
        this.func_70107_b(x, y, z);
        this.casterReference = new WeakReference<EntityLivingBase>(caster);
        this.field_70728_aV = 0;
        this.lifetime = lifetime;
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
    }

    @Override
    public void onSpawn() {
    }

    @Override
    public void onDespawn() {
    }

    @Override
    public boolean hasParticleEffect() {
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.writeNBTDelegate(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.readNBTDelegate(nbttagcompound);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType) || this.hasRangedAttack();
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.wizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.showSummonedCreatureNames && this.getCaster() != null;
    }

    public abstract boolean hasRangedAttack();
}

