/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardryAchievements;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWand
extends Item {
    public Tier tier;
    public Element element;

    public ItemWand(Tier tier, Element element) {
        this.func_77625_d(1);
        if (element == null || tier == Tier.BASIC) {
            this.func_77637_a(WizardryTabs.WIZARDRY);
        }
        this.tier = tier;
        this.element = element;
        this.func_77656_e(this.tier.maxCharge);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item parItem, CreativeTabs parTab, NonNullList<ItemStack> parListSubItems) {
        parListSubItems.add((Object)new ItemStack((Item)this, 1));
    }

    public int getMaxDamage(ItemStack itemstack) {
        return (int)((float)super.getMaxDamage(itemstack) * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel(itemstack, WizardryItems.storage_upgrade)) + 0.5f);
    }

    public void func_77622_d(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71029_a((StatBase)WizardryAchievements.arcane_initiate);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean isHeld) {
        WandHelper.decrementCooldowns(itemstack);
        if (!world.field_72995_K && itemstack.func_77951_h() && world.func_72820_D() % 50L == 0L) {
            itemstack.func_77964_b(itemstack.func_77952_i() - WandHelper.getUpgradeLevel(itemstack, WizardryItems.condenser_upgrade));
        }
        if (entity instanceof EntityPlayer && this.element != null && this.element != Element.MAGIC) {
            ((EntityPlayer)entity).func_71029_a((StatBase)WizardryAchievements.elemental);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged || !(oldStack.func_77973_b() instanceof ItemWand) || !(newStack.func_77973_b() instanceof ItemWand) || WandHelper.getCurrentSpell(oldStack) != WandHelper.getCurrentSpell(newStack))) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return WandHelper.getCurrentSpell((ItemStack)itemstack).action;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> text, boolean advanced) {
        if (this.element != null) {
            text.add("\u00a78" + I18n.func_135052_a((String)"item.wizardry:wand.buff", (Object[])new Object[]{(int)((float)(this.tier.level + 1) * 0.15f * 100.0f + 0.5f) + "%", this.element.getDisplayName()}));
        }
        Spell spell = WandHelper.getCurrentSpell(itemstack);
        boolean discovered = true;
        if (Wizardry.settings.discoveryMode && !player.field_71075_bZ.field_75098_d && WizardData.get(player) != null && !WizardData.get(player).hasSpellBeenDiscovered(spell)) {
            discovered = false;
        }
        text.add("\u00a77" + I18n.func_135052_a((String)"item.wizardry:wand.spell", (Object[])new Object[]{discovered ? "\u00a77" + spell.getDisplayNameWithFormatting() : "#\u00a79" + SpellGlyphData.getGlyphName(spell, player.field_70170_p)}));
        text.add("\u00a79" + I18n.func_135052_a((String)"item.wizardry:wand.mana", (Object[])new Object[]{this.getMaxDamage(itemstack) - this.getDamage(itemstack), this.getMaxDamage(itemstack)}));
    }

    public String func_77653_i(ItemStack stack) {
        return (this.element == null ? "" : this.element.getFormattingCode()) + super.func_77653_i(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellModifiers modifiers;
        ItemStack stack = player.func_184586_b(hand);
        if (this.selectMinionTarget(player, world)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        Spell spell = WandHelper.getCurrentSpell(stack);
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre((EntityLivingBase)player, spell, modifiers = this.calculateModifiers(stack, spell), SpellCastEvent.Source.WAND))) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (spell.isContinuous && !player.func_184587_cr()) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!spell.isContinuous && spell.tier.level <= this.tier.level && spell.cost <= stack.func_77958_k() - stack.func_77952_i() && (WandHelper.getCurrentCooldown(stack) == 0 || player.field_71075_bZ.field_75098_d)) {
            if (!world.field_72995_K) {
                if (spell.cast(world, player, hand, 0, modifiers)) {
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)player, spell, modifiers, SpellCastEvent.Source.WAND));
                    if (spell.doesSpellRequirePacket()) {
                        PacketCastSpell.Message msg = new PacketCastSpell.Message(player.func_145782_y(), hand, spell.id(), modifiers);
                        WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                    }
                    player.func_184598_c(hand);
                    if (!player.field_71075_bZ.field_75098_d) {
                        float cooldownMultiplier = 1.0f - (float)WandHelper.getUpgradeLevel(stack, WizardryItems.cooldown_upgrade) * 0.15f;
                        if (player.func_70644_a(WizardryPotions.font_of_mana)) {
                            cooldownMultiplier /= (float)(2 + player.func_70660_b(WizardryPotions.font_of_mana).func_76458_c());
                        }
                        WandHelper.setCurrentCooldown(stack, (int)((float)spell.cooldown * cooldownMultiplier));
                    }
                    int armourPieces = this.getMatchingArmourCount(player, spell);
                    stack.func_77972_a((int)((float)spell.cost * (1.0f - (float)armourPieces * 0.2f)), (EntityLivingBase)player);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (!spell.doesSpellRequirePacket() && spell.cast(world, player, hand, 0, modifiers)) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)player, spell, modifiers, SpellCastEvent.Source.WAND));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            int castingTick;
            SpellModifiers modifiers;
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell(stack);
            if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick((EntityLivingBase)player, spell, modifiers = this.calculateModifiers(stack, spell), SpellCastEvent.Source.WAND, castingTick = stack.func_77988_m() - count))) {
                return;
            }
            if (spell.isContinuous && spell.tier.level <= this.tier.level && spell.cost / 5 <= stack.func_77958_k() - stack.func_77952_i() && spell.cast(player.field_70170_p, player, player.func_184600_cs(), castingTick, modifiers)) {
                int tickNumber;
                if (castingTick == 0) {
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)player, spell, modifiers, SpellCastEvent.Source.WAND));
                }
                if ((tickNumber = count % 20 + 1) % 4 == 1) {
                    int armourPieces = this.getMatchingArmourCount(player, spell);
                    switch (armourPieces) {
                        case 0: {
                            stack.func_77972_a(spell.cost / 5, (EntityLivingBase)player);
                            break;
                        }
                        case 1: {
                            if (tickNumber == 17) break;
                            stack.func_77972_a(spell.cost / 5, (EntityLivingBase)player);
                            break;
                        }
                        case 2: {
                            if (tickNumber == 9 || tickNumber == 17) break;
                            stack.func_77972_a(spell.cost / 5, (EntityLivingBase)player);
                            break;
                        }
                        case 3: {
                            if (tickNumber == 5 || tickNumber == 13 || tickNumber == 17) break;
                            stack.func_77972_a(spell.cost / 5, (EntityLivingBase)player);
                            break;
                        }
                        case 4: {
                            if (tickNumber != 1) break;
                            stack.func_77972_a(spell.cost / 5, (EntityLivingBase)player);
                        }
                    }
                }
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (player.func_70093_af() && entity instanceof EntityPlayer && WizardData.get(player) != null) {
            String string;
            String string2 = string = WizardData.get(player).toggleAlly((EntityPlayer)entity) ? "item.wizardry:wand.addally" : "item.wizardry:wand.removeally";
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(string, new Object[]{entity.func_70005_c_()}));
            }
            return true;
        }
        return false;
    }

    protected SpellModifiers calculateModifiers(ItemStack stack, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel(stack, WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * 0.25f, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * 0.25f, false);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * 0.25f, true);
        }
        if (this.element == spell.element) {
            modifiers.set("damage", 1.0f + (float)(this.tier.level + 1) * 0.15f, true);
        }
        return modifiers;
    }

    private int getMatchingArmourCount(EntityPlayer player, Spell spell) {
        int armourPieces = 0;
        for (EntityEquipmentSlot slot : WizardryUtilities.ARMOUR_SLOTS) {
            ItemStack armour = player.func_184582_a(slot);
            if (armour == null || !(armour.func_77973_b() instanceof ItemWizardArmour) || ((ItemWizardArmour)armour.func_77973_b()).element != spell.element) continue;
            ++armourPieces;
        }
        return armourPieces;
    }

    private boolean selectMinionTarget(EntityPlayer player, World world) {
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)player, 16.0);
        if (rayTrace != null && WizardryUtilities.isLiving(rayTrace.field_72308_g)) {
            ISummonedCreature minion;
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (player.func_70093_af() && WizardData.get(player) != null && WizardData.get((EntityPlayer)player).selectedMinion != null && (minion = (ISummonedCreature)WizardData.get((EntityPlayer)player).selectedMinion.get()) instanceof EntityLiving && minion != entity) {
                ((EntityLiving)minion).func_70624_b(entity);
                WizardData.get((EntityPlayer)player).selectedMinion = null;
                return true;
            }
        }
        return false;
    }
}

