/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.potion.PotionDecay;
import electroblob.wizardry.potion.PotionFrost;
import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.potion.PotionMagicEffectParticles;
import electroblob.wizardry.util.WizardryParticleType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public final class WizardryPotions {
    public static final Potion frost = new PotionFrost(true, 0);
    public static final Potion transience = new PotionMagicEffectParticles(false, 0, 0){

        @Override
        public void spawnCustomParticle(World world, double x, double y, double z) {
            Wizardry.proxy.spawnParticle(WizardryParticleType.DUST, world, x, y, z, 0.0, 0.0, 0.0, (int)(16.0 / (Math.random() * 0.8 + 0.2)), 0.8f, 0.8f, 1.0f);
        }
    }.func_188413_j();
    public static final Potion fireskin = new PotionMagicEffectParticles(false, 0, 1){

        @Override
        public void spawnCustomParticle(World world, double x, double y, double z) {
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }

        @Override
        public void func_76394_a(EntityLivingBase entitylivingbase, int strength) {
            entitylivingbase.func_70066_B();
        }
    }.func_188413_j();
    public static final Potion ice_shroud = new PotionMagicEffectParticles(false, 0, 2){

        @Override
        public void spawnCustomParticle(World world, double x, double y, double z) {
            float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
            Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x, y, z, 0.0, 0.0, 0.0, 48 + world.field_73012_v.nextInt(12), brightness, brightness + 0.1f, 1.0f, true, 0.0);
            Wizardry.proxy.spawnParticle(WizardryParticleType.SNOW, world, x, y, z, 0.0, -0.02, 0.0, 40 + world.field_73012_v.nextInt(10));
        }
    }.func_188413_j();
    public static final Potion static_aura = new PotionMagicEffectParticles(false, 0, 3){

        @Override
        public void spawnCustomParticle(World world, double x, double y, double z) {
            Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, x, y, z, 0.0, 0.0, 0.0, 3);
        }
    }.func_188413_j();
    public static final Potion decay = new PotionDecay(true, 3932268);
    public static final Potion sixth_sense = new PotionMagicEffect(false, 13041409, 4).func_188413_j();
    public static final Potion arcane_jammer = new PotionMagicEffect(false, 13585058, 5);
    public static final Potion mind_trick = new PotionMagicEffect(true, 6297219, 6);
    public static final Potion mind_control = new PotionMagicEffect(true, 3279684, 7);
    public static final Potion font_of_mana = new PotionMagicEffect(false, 16770491, 8).func_188413_j();
    public static final Potion fear = new PotionMagicEffect(true, 12386560, 9);

    public static void registerPotion(IForgeRegistry<Potion> registry, Potion potion, String name) {
        potion.setRegistryName("wizardry", name);
        potion.func_76390_b("potion." + potion.getRegistryName().toString());
        registry.register((IForgeRegistryEntry)potion);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, frost, "frost");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, transience, "transience");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, fireskin, "fireskin");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, ice_shroud, "ice_shroud");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, static_aura, "static_aura");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, decay, "decay");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, sixth_sense, "sixth_sense");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, arcane_jammer, "arcane_jammer");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, mind_trick, "mind_trick");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, mind_control, "mind_control");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, font_of_mana, "font_of_mana");
        WizardryPotions.registerPotion((IForgeRegistry<Potion>)registry, fear, "fear");
    }
}

